/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads.executor;

import io.appulse.utils.threads.executor.ExecutorServiceWrapper;
import java.util.concurrent.ExecutorService;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorServiceWithClientTrace
extends ExecutorServiceWrapper {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceWithClientTrace.class);
    private static final String EXCEPTION_SEPARATOR = "------ submitted from: ------";

    public ExecutorServiceWithClientTrace(ExecutorService delegate) {
        super(delegate);
    }

    @Override
    public void execute(@NonNull Runnable command) {
        if (command == null) {
            throw new NullPointerException("command");
        }
        Exception clientStack = new Exception("Client stack trace");
        String threadName = Thread.currentThread().getName();
        super.execute(() -> {
            try {
                command.run();
            }
            catch (Exception ex) {
                log.error("Exception during task execution submitted from thread '{}'", (Object)threadName, (Object)this.merge(clientStack, ex));
                throw ex;
            }
        });
    }

    private Throwable merge(Exception local, Exception remote) {
        Exception result = remote;
        StackTraceElement[] remoteStackTrace = remote.getStackTrace();
        StackTraceElement[] localStackTrace = local.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localStackTrace.length + remoteStackTrace.length];
        System.arraycopy(remoteStackTrace, 0, newStackTrace, 0, remoteStackTrace.length);
        newStackTrace[remoteStackTrace.length] = new StackTraceElement(EXCEPTION_SEPARATOR, "", "", -1);
        System.arraycopy(localStackTrace, 1, newStackTrace, remoteStackTrace.length + 1, localStackTrace.length - 1);
        result.setStackTrace(newStackTrace);
        return result;
    }
}

