/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils.threads.executor.builder;

import io.appulse.utils.threads.executor.ScheduledExecutorServiceWithClientTrace;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.NonNull;

public final class ScheduledExecutorServiceBuilder {
    private static final RejectedExecutionHandler DEFAULT_HANDLER = new ThreadPoolExecutor.AbortPolicy();
    private int poolSize = 1;
    private boolean continueExistingPeriodicTasksAfterShutdownPolicy;
    private boolean executeExistingDelayedTasksAfterShutdownPolicy = true;
    private boolean removeOnCancelPolicy;
    private boolean useClientTrace;
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler handler;

    public ScheduledExecutorServiceBuilder poolSize(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Pool size must be greater than 0");
        }
        this.poolSize = value;
        return this;
    }

    public ScheduledExecutorServiceBuilder continueExistingPeriodicTasksAfterShutdownPolicy() {
        return this.continueExistingPeriodicTasksAfterShutdownPolicy(true);
    }

    public ScheduledExecutorServiceBuilder continueExistingPeriodicTasksAfterShutdownPolicy(boolean value) {
        this.continueExistingPeriodicTasksAfterShutdownPolicy = value;
        return this;
    }

    public ScheduledExecutorServiceBuilder executeExistingDelayedTasksAfterShutdownPolicy() {
        return this.executeExistingDelayedTasksAfterShutdownPolicy(true);
    }

    public ScheduledExecutorServiceBuilder executeExistingDelayedTasksAfterShutdownPolicy(boolean value) {
        this.executeExistingDelayedTasksAfterShutdownPolicy = value;
        return this;
    }

    public ScheduledExecutorServiceBuilder removeOnCancelPolicy() {
        return this.removeOnCancelPolicy(true);
    }

    public ScheduledExecutorServiceBuilder removeOnCancelPolicy(boolean value) {
        this.removeOnCancelPolicy = value;
        return this;
    }

    public ScheduledExecutorServiceBuilder clientTrace() {
        return this.clientTrace(true);
    }

    public ScheduledExecutorServiceBuilder clientTrace(boolean value) {
        this.useClientTrace = value;
        return this;
    }

    public ScheduledExecutorServiceBuilder threadFactory(@NonNull ThreadFactory value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.threadFactory = value;
        return this;
    }

    public ScheduledExecutorServiceBuilder handler(@NonNull RejectedExecutionHandler value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.handler = value;
        return this;
    }

    public ScheduledExecutorService build() {
        if (this.poolSize < 1) {
            throw new IllegalArgumentException("Pool size must be greater than 0");
        }
        this.threadFactory = Optional.ofNullable(this.threadFactory).orElse(Executors.defaultThreadFactory());
        this.handler = Optional.ofNullable(this.handler).orElse(DEFAULT_HANDLER);
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(this.poolSize, this.threadFactory, this.handler);
        result.setContinueExistingPeriodicTasksAfterShutdownPolicy(this.continueExistingPeriodicTasksAfterShutdownPolicy);
        result.setExecuteExistingDelayedTasksAfterShutdownPolicy(this.executeExistingDelayedTasksAfterShutdownPolicy);
        result.setRemoveOnCancelPolicy(this.removeOnCancelPolicy);
        return this.useClientTrace ? new ScheduledExecutorServiceWithClientTrace(result) : result;
    }
}

