/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.BytesUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import lombok.NonNull;

public final class ResourceUtils {
    public static Optional<String> getResource(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        return ResourceUtils.getResource(name, StandardCharsets.UTF_8);
    }

    public static Optional<String> getResource(@NonNull String name, @NonNull Charset charset) {
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked @NonNull but is null");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(name);
        if (inputStream == null && (inputStream = ResourceUtils.class.getResourceAsStream(name)) == null) {
            return Optional.empty();
        }
        byte[] bytes = BytesUtils.read(inputStream);
        String string = new String(bytes, charset);
        return Optional.of(string);
    }

    private ResourceUtils() {
    }
}

