/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public final class SocketUtils {
    public static Optional<Integer> findFreePort() {
        return SocketUtils.findFreePort(1024, 65535);
    }

    public static Optional<Integer> findFreePort(int from, int to) {
        for (int port = to; port >= from; --port) {
            if (!SocketUtils.isPortAvailable(port)) continue;
            return Optional.of(port);
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("localhost", port), (int)TimeUnit.SECONDS.toMillis(1L));
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            return true;
        }
    }

    public static byte[] read(@NonNull Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket is marked @NonNull but is null");
        }
        return BytesUtils.read(socket.getInputStream());
    }

    public static byte[] read(@NonNull Socket socket, int length) {
        if (socket == null) {
            throw new NullPointerException("socket is marked @NonNull but is null");
        }
        return BytesUtils.read(socket.getInputStream(), length);
    }

    public static Bytes readBytes(@NonNull Socket socket) {
        if (socket == null) {
            throw new NullPointerException("socket is marked @NonNull but is null");
        }
        return BytesUtils.readBytes(socket.getInputStream());
    }

    public static Bytes readBytes(@NonNull Socket socket, int fixedLength) {
        if (socket == null) {
            throw new NullPointerException("socket is marked @NonNull but is null");
        }
        return BytesUtils.readBytes(socket.getInputStream(), fixedLength);
    }

    private SocketUtils() {
    }
}

