/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.cloudsql.postgres;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.plugin.db.connector.AbstractDBConnectorConfig;
import javax.annotation.Nullable;

public class CloudSQLPostgreSQLConnectorConfig
extends AbstractDBConnectorConfig {
    @Name(value="connectionName")
    @Description(value="The CloudSQL instance to connect to. For a public instance, the connection string should be in the format <PROJECT_ID>:<REGION>:<INSTANCE_NAME> which can be found in the instance overview page. For a private instance, enter the internal IP address of the Compute Engine VM cloudsql proxy is running on.")
    @Macro
    private String connectionName;
    @Name(value="port")
    @Description(value="Database port number")
    @Macro
    @Nullable
    private Integer port;
    @Name(value="database")
    @Description(value="Database name to connect to")
    @Macro
    private String database;
    @Name(value="instanceType")
    @Description(value="Whether the CloudSQL instance to connect to is private or public.")
    private String instanceType;

    public CloudSQLPostgreSQLConnectorConfig(String username, String password, String jdbcPluginName, String connectionArguments, String instanceType, String connectionName, String database, @Nullable Integer port) {
        this.user = username;
        this.password = password;
        this.jdbcPluginName = jdbcPluginName;
        this.connectionArguments = connectionArguments;
        this.instanceType = instanceType;
        this.connectionName = connectionName;
        this.database = database;
        this.port = port;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public int getPort() {
        return this.port == null ? 5432 : this.port;
    }

    public String getConnectionString() {
        if ("private".equalsIgnoreCase(this.instanceType)) {
            return String.format("jdbc:postgresql://%s:%s/%s", this.connectionName, this.getPort(), this.database);
        }
        return String.format("jdbc:postgresql:///%s?cloudSqlInstance=%s&socketFactory=com.google.cloud.sql.postgres.SocketFactory", this.database, this.connectionName);
    }

    public boolean canConnect() {
        return super.canConnect() && !this.containsMacro("connectionName") && !this.containsMacro("port") && !this.containsMacro("database");
    }
}

