/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.plugin.common.KeyValueListParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class ConnectionConfig
extends PluginConfig {
    public static final String CONNECTION_STRING = "connectionString";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String CONNECTION_ARGUMENTS = "connectionArguments";
    public static final String JDBC_PLUGIN_NAME = "jdbcPluginName";
    public static final String JDBC_PLUGIN_TYPE = "jdbcPluginType";
    public static final String COLUMN_NAME_CASE = "columnNameCase";
    public static final String ENABLE_AUTO_COMMIT = "enableAutoCommit";
    @Name(value="connectionString")
    @Description(value="JDBC connection string including database name.")
    @Macro
    public String connectionString;
    @Name(value="user")
    @Description(value="User to use to connect to the specified database. Required for databases that need authentication. Optional for databases that do not require authentication.")
    @Nullable
    @Macro
    public String user;
    @Name(value="password")
    @Description(value="Password to use to connect to the specified database. Required for databases that need authentication. Optional for databases that do not require authentication.")
    @Nullable
    @Macro
    public String password;
    @Name(value="connectionArguments")
    @Description(value="A list of arbitrary string tag/value pairs as connection arguments. This is a semicolon-separated list of key-value pairs, where each pair is separated by a equals '=' and specifies the key and value for the argument. For example, 'key1=value1;key2=value' specifies that the connection will be given arguments 'key1' mapped to 'value1' and the argument 'key2' mapped to 'value2'.")
    @Nullable
    @Macro
    public String connectionArguments;
    @Name(value="jdbcPluginName")
    @Description(value="Name of the JDBC plugin to use. This is the value of the 'name' key defined in the JSON file for the JDBC plugin.")
    public String jdbcPluginName;
    @Name(value="jdbcPluginType")
    @Description(value="Type of the JDBC plugin to use. This is the value of the 'type' key defined in the JSON file for the JDBC plugin. Defaults to 'jdbc'.")
    @Nullable
    public String jdbcPluginType = "jdbc";
    @Name(value="enableAutoCommit")
    @Description(value="Whether to enable auto commit for queries run by this source. Defaults to false. This setting should only matter if you are using a jdbc driver that does not support a false value for auto commit, or a driver that does not support the commit call. For example, the Hive jdbc driver will throw an exception whenever a commit is called. For drivers like that, this should be set to true.")
    @Nullable
    public Boolean enableAutoCommit = false;

    public static Properties getConnectionArguments(@Nullable String connectionArguments, @Nullable String user, @Nullable String password) {
        KeyValueListParser kvParser = new KeyValueListParser("\\s*;\\s*", "=");
        HashMap<Object, Object> connectionArgumentsMap = new HashMap<Object, Object>();
        if (!Strings.isNullOrEmpty((String)connectionArguments)) {
            for (KeyValue keyVal : kvParser.parse(connectionArguments)) {
                connectionArgumentsMap.put(keyVal.getKey(), keyVal.getValue());
            }
        }
        if (user != null) {
            connectionArgumentsMap.put(USER, user);
            connectionArgumentsMap.put(PASSWORD, password);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)connectionArgumentsMap);
        return properties;
    }

    public Properties getConnectionArguments() {
        return ConnectionConfig.getConnectionArguments(this.connectionArguments, this.user, this.password);
    }
}

