/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.plugin.ConnectionConfig;
import javax.annotation.Nullable;

public class DBConfig
extends ConnectionConfig {
    @Name(value="referenceName")
    @Description(value="This will be used to uniquely identify this source/sink for lineage, annotating metadata, etc.")
    public String referenceName;
    @Name(value="columnNameCase")
    @Description(value="Sets the case of the column names returned from the query. Possible options are upper or lower. By default or for any other input, the column names are not modified and the names returned from the database are used as-is. Note that setting this property provides predictability of column name cases across different databases but might result in column name conflicts if multiple column names are the same when the case is ignored.")
    @Nullable
    @Macro
    public String columnNameCase;

    public Boolean getEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    protected String cleanQuery(@Nullable String query) {
        if (query == null) {
            return null;
        }
        if ((query = query.trim()).isEmpty()) {
            return query;
        }
        int idx = query.length() - 1;
        char currChar = query.charAt(idx);
        while (idx > 0 && currChar == ';' || Character.isWhitespace(currChar)) {
            currChar = query.charAt(--idx);
        }
        if (idx == 0) {
            return "";
        }
        return query.substring(0, idx + 1);
    }
}

