/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import com.google.common.base.Preconditions;
import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.etl.api.Destroyable;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.plugin.ConnectionConfig;
import io.cdap.plugin.DBUtils;
import io.cdap.plugin.DriverCleanup;
import java.sql.Driver;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(DBManager.class);
    private final ConnectionConfig config;
    private DriverCleanup driverCleanup;

    public DBManager(ConnectionConfig config) {
        this.config = config;
    }

    public Class<? extends Driver> validateJDBCPluginPipeline(PipelineConfigurer pipelineConfigurer, String jdbcPluginId) {
        Preconditions.checkArgument((this.config.user != null || this.config.password == null ? 1 : 0) != 0, (Object)"user is null. Please provide both user name and password if database requires authentication. If not, please remove password and retry.");
        Class jdbcDriverClass = pipelineConfigurer.usePluginClass(this.config.jdbcPluginType, this.config.jdbcPluginName, jdbcPluginId, PluginProperties.builder().build());
        Preconditions.checkArgument((jdbcDriverClass != null ? 1 : 0) != 0, (String)"Unable to load JDBC Driver class for plugin name '%s'. Please make sure that the plugin '%s' of type '%s' containing the driver has been installed correctly.", (Object[])new Object[]{this.config.jdbcPluginName, this.config.jdbcPluginName, this.config.jdbcPluginType});
        return jdbcDriverClass;
    }

    /*
     * Exception decompiling
     */
    public boolean tableExists(Class<? extends Driver> jdbcDriverClass, String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ensureJDBCDriverIsAvailable(Class<? extends Driver> jdbcDriverClass) throws IllegalAccessException, InstantiationException, SQLException {
        this.driverCleanup = DBUtils.ensureJDBCDriverIsAvailable(jdbcDriverClass, this.config.connectionString, this.config.jdbcPluginType, this.config.jdbcPluginName);
    }

    public void destroy() {
        if (this.driverCleanup != null) {
            this.driverCleanup.destroy();
        }
    }
}

