/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import com.google.common.base.Preconditions;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.DBUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

public class DBRecord
implements Writable,
DBWritable,
Configurable {
    private StructuredRecord record;
    private Configuration conf;
    private int[] columnTypes;

    public DBRecord(StructuredRecord record, int[] columnTypes) {
        this.record = record;
        this.columnTypes = columnTypes;
    }

    public DBRecord() {
    }

    public void readFields(DataInput in) throws IOException {
    }

    public StructuredRecord getRecord() {
        return this.record;
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metadata = resultSet.getMetaData();
        List<Schema.Field> schemaFields = DBUtils.getSchemaFields(resultSet, this.conf.get("io.cdap.hydrator.db.override.schema"));
        Schema schema = Schema.recordOf((String)"dbRecord", schemaFields);
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)schema);
        for (int i = 0; i < schemaFields.size(); ++i) {
            Schema.Field field = schemaFields.get(i);
            int sqlType = metadata.getColumnType(i + 1);
            int sqlPrecision = metadata.getPrecision(i + 1);
            int sqlScale = metadata.getScale(i + 1);
            this.setField(resultSet, recordBuilder, field, sqlType, sqlPrecision, sqlScale);
        }
        this.record = recordBuilder.build();
    }

    private void setField(ResultSet resultSet, StructuredRecord.Builder recordBuilder, Schema.Field field, int sqlType, int sqlPrecision, int sqlScale) throws SQLException {
        Object o = DBUtils.transformValue(sqlType, sqlPrecision, sqlScale, resultSet, field.getName());
        if (o instanceof Date) {
            recordBuilder.setDate(field.getName(), ((Date)o).toLocalDate());
        } else if (o instanceof Time) {
            recordBuilder.setTime(field.getName(), ((Time)o).toLocalTime());
        } else if (o instanceof Timestamp) {
            Instant instant = ((Timestamp)o).toInstant();
            recordBuilder.setTimestamp(field.getName(), instant.atZone(ZoneId.ofOffset("UTC", ZoneOffset.UTC)));
        } else {
            recordBuilder.set(field.getName(), o);
        }
    }

    public void write(DataOutput out) throws IOException {
        Schema recordSchema = this.record.getSchema();
        List schemaFields = recordSchema.getFields();
        for (Schema.Field field : schemaFields) {
            this.writeToDataOut(out, field);
        }
    }

    public void write(PreparedStatement stmt) throws SQLException {
        Schema recordSchema = this.record.getSchema();
        List schemaFields = recordSchema.getFields();
        for (int i = 0; i < schemaFields.size(); ++i) {
            this.writeToDB(stmt, (Schema.Field)schemaFields.get(i), i);
        }
    }

    private Schema getNonNullableSchema(Schema.Field field) {
        Schema schema = field.getSchema();
        if (field.getSchema().isNullable()) {
            schema = field.getSchema().getNonNullable();
        }
        Preconditions.checkArgument((boolean)schema.getType().isSimpleType(), (String)"Only simple types are supported (boolean, int, long, float, double, string, bytes) for writing a DBRecord, but found '%s' as the type for column '%s'. Please remove this column or transform it to a simple type.", (Object[])new Object[]{schema.getType(), field.getName()});
        return schema;
    }

    private void writeToDataOut(DataOutput out, Schema.Field field) throws IOException {
        Schema fieldSchema = this.getNonNullableSchema(field);
        Schema.Type fieldType = fieldSchema.getType();
        Object fieldValue = this.record.get(field.getName());
        if (fieldValue == null) {
            return;
        }
        switch (fieldType) {
            case NULL: {
                break;
            }
            case STRING: {
                out.writeUTF((String)fieldValue);
                break;
            }
            case BOOLEAN: {
                out.writeBoolean((Boolean)fieldValue);
                break;
            }
            case INT: {
                out.writeInt((Integer)fieldValue);
                break;
            }
            case LONG: {
                out.writeLong((Long)fieldValue);
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)fieldValue).floatValue());
                break;
            }
            case DOUBLE: {
                out.writeDouble((Double)fieldValue);
                break;
            }
            case BYTES: {
                out.write((byte[])fieldValue);
                break;
            }
            default: {
                throw new IOException(String.format("Unsupported datatype: %s with value: %s.", fieldType, fieldValue));
            }
        }
    }

    private void writeToDB(PreparedStatement stmt, Schema.Field field, int fieldIndex) throws SQLException {
        String fieldName = field.getName();
        Schema fieldSchema = this.getNonNullableSchema(field);
        Schema.Type fieldType = fieldSchema.getType();
        Schema.LogicalType fieldLogicalType = fieldSchema.getLogicalType();
        Object fieldValue = this.record.get(fieldName);
        int sqlIndex = fieldIndex + 1;
        if (fieldValue == null) {
            stmt.setNull(sqlIndex, this.columnTypes[fieldIndex]);
            return;
        }
        if (fieldLogicalType != null) {
            switch (fieldLogicalType) {
                case DATE: {
                    stmt.setDate(sqlIndex, Date.valueOf(this.record.getDate(fieldName)));
                    break;
                }
                case TIME_MILLIS: 
                case TIME_MICROS: {
                    stmt.setTime(sqlIndex, Time.valueOf(this.record.getTime(fieldName)));
                    break;
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    stmt.setTimestamp(sqlIndex, Timestamp.from(this.record.getTimestamp(fieldName).toInstant()));
                }
            }
            return;
        }
        switch (fieldType) {
            case NULL: {
                stmt.setNull(sqlIndex, this.columnTypes[fieldIndex]);
                break;
            }
            case STRING: {
                stmt.setString(sqlIndex, (String)fieldValue);
                break;
            }
            case BOOLEAN: {
                stmt.setBoolean(sqlIndex, (Boolean)fieldValue);
                break;
            }
            case INT: {
                this.writeInt(stmt, fieldIndex, sqlIndex, fieldValue);
                break;
            }
            case LONG: {
                stmt.setLong(sqlIndex, (Long)fieldValue);
                break;
            }
            case FLOAT: {
                stmt.setFloat(sqlIndex, ((Float)fieldValue).floatValue());
                break;
            }
            case DOUBLE: {
                stmt.setDouble(sqlIndex, (Double)fieldValue);
                break;
            }
            case BYTES: {
                this.writeBytes(stmt, fieldIndex, sqlIndex, fieldValue);
                break;
            }
            default: {
                throw new SQLException(String.format("Unsupported datatype: %s with value: %s.", fieldType, fieldValue));
            }
        }
    }

    private void writeBytes(PreparedStatement stmt, int fieldIndex, int sqlIndex, Object fieldValue) throws SQLException {
        byte[] byteValue = fieldValue instanceof ByteBuffer ? Bytes.toBytes((ByteBuffer)((ByteBuffer)fieldValue)) : (byte[])fieldValue;
        int parameterType = this.columnTypes[fieldIndex];
        if (2004 == parameterType) {
            stmt.setBlob(sqlIndex, new SerialBlob(byteValue));
            return;
        }
        stmt.setBytes(sqlIndex, byteValue);
    }

    private void writeInt(PreparedStatement stmt, int fieldIndex, int sqlIndex, Object fieldValue) throws SQLException {
        Integer intValue = (Integer)fieldValue;
        int parameterType = this.columnTypes[fieldIndex];
        if (-6 == parameterType || 5 == parameterType) {
            stmt.setShort(sqlIndex, intValue.shortValue());
            return;
        }
        stmt.setInt(sqlIndex, intValue);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

