/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.action;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.action.Action;
import io.cdap.cdap.etl.api.action.ActionContext;
import io.cdap.plugin.DBManager;
import io.cdap.plugin.db.batch.action.DBRun;
import io.cdap.plugin.db.batch.action.QueryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="action")
@Name(value="Database")
@Description(value="Action that runs a db command")
public class DBAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(DBAction.class);
    private static final String JDBC_PLUGIN_ID = "driver";
    private final QueryConfig config;

    public DBAction(QueryConfig config) {
        this.config = config;
    }

    public void run(ActionContext context) throws Exception {
        Class driverClass = context.loadPluginClass(JDBC_PLUGIN_ID);
        DBRun executeQuery = new DBRun(this.config, driverClass);
        executeQuery.run();
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) throws IllegalArgumentException {
        DBManager dbManager = new DBManager(this.config);
        dbManager.validateJDBCPluginPipeline(pipelineConfigurer, JDBC_PLUGIN_ID);
    }
}

