/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.action;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.cdap.etl.api.batch.BatchActionContext;
import io.cdap.cdap.etl.api.batch.PostAction;
import io.cdap.plugin.DBManager;
import io.cdap.plugin.common.batch.action.Condition;
import io.cdap.plugin.common.batch.action.ConditionConfig;
import io.cdap.plugin.db.batch.action.DBRun;
import io.cdap.plugin.db.batch.action.QueryConfig;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="postaction")
@Name(value="DatabaseQuery")
@Description(value="Runs a query after a pipeline run.")
public class QueryAction
extends PostAction {
    private static final String JDBC_PLUGIN_ID = "driver";
    private static final Logger LOG = LoggerFactory.getLogger(QueryAction.class);
    private final QueryActionConfig config;

    public QueryAction(QueryActionConfig config) {
        this.config = config;
    }

    public void run(BatchActionContext batchContext) throws Exception {
        this.config.validate();
        if (!this.config.shouldRun(batchContext)) {
            return;
        }
        Class driverClass = batchContext.loadPluginClass(JDBC_PLUGIN_ID);
        DBRun executeQuery = new DBRun(this.config, driverClass);
        executeQuery.run();
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) throws IllegalArgumentException {
        this.config.validate();
        DBManager dbManager = new DBManager(this.config);
        dbManager.validateJDBCPluginPipeline(pipelineConfigurer, JDBC_PLUGIN_ID);
    }

    public class QueryActionConfig
    extends QueryConfig {
        @Nullable
        @Description(value="When to run the action. Must be 'completion', 'success', or 'failure'. Defaults to 'success'. If set to 'completion', the action will be executed regardless of whether the pipeline run succeeded or failed. If set to 'success', the action will only be executed if the pipeline run succeeded. If set to 'failure', the action will only be executed if the pipeline run failed.")
        @Macro
        public String runCondition = Condition.SUCCESS.name();

        public void validate() {
            if (!this.containsMacro("runCondition")) {
                new ConditionConfig(this.runCondition).validate();
            }
        }

        public boolean shouldRun(BatchActionContext actionContext) {
            return new ConditionConfig(this.runCondition).shouldRun(actionContext);
        }
    }
}

