/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import io.cdap.cdap.api.plugin.PluginProperties;
import io.cdap.cdap.etl.api.Destroyable;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.plugin.ConnectionConfig;
import io.cdap.plugin.DBUtils;
import io.cdap.plugin.DriverCleanup;
import java.sql.Driver;
import java.sql.SQLException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBManager
implements Destroyable {
    private static final Logger LOG = LoggerFactory.getLogger(DBManager.class);
    private final ConnectionConfig config;
    private DriverCleanup driverCleanup;

    public DBManager(ConnectionConfig config) {
        this.config = config;
    }

    @Nullable
    public Class<? extends Driver> validateJDBCPluginPipeline(PipelineConfigurer pipelineConfigurer, String jdbcPluginId, FailureCollector collector) {
        Class jdbcDriverClass;
        if (!this.config.containsMacro("user") && !this.config.containsMacro("password") && this.config.user == null && this.config.password != null) {
            collector.addFailure("Username and password should be provided together.", "Please provide both user name and password, if database supports it or remove password.").withConfigProperty("user").withConfigProperty("password");
        }
        if ((jdbcDriverClass = pipelineConfigurer.usePluginClass(this.config.jdbcPluginType, this.config.jdbcPluginName, jdbcPluginId, PluginProperties.builder().build())) == null) {
            collector.addFailure(String.format("Unable to load JDBC Driver class for plugin name '%s'.", this.config.jdbcPluginName), String.format("Ensure that plugin '%s' of type '%s' containing the driver has been deployed.", this.config.jdbcPluginName, this.config.jdbcPluginType)).withConfigProperty("jdbcPluginName").withPluginNotFound(jdbcPluginId, this.config.jdbcPluginName, this.config.jdbcPluginType);
        }
        return jdbcDriverClass;
    }

    /*
     * Exception decompiling
     */
    public boolean tableExists(Class<? extends Driver> jdbcDriverClass, String tableName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ensureJDBCDriverIsAvailable(Class<? extends Driver> jdbcDriverClass) throws IllegalAccessException, InstantiationException, SQLException {
        this.driverCleanup = DBUtils.ensureJDBCDriverIsAvailable(jdbcDriverClass, this.config.connectionString, this.config.jdbcPluginType, this.config.jdbcPluginName);
    }

    public void destroy() {
        if (this.driverCleanup != null) {
            this.driverCleanup.destroy();
        }
    }
}

