/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.DataSizeReporter;
import io.cdap.plugin.common.db.DBUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.rowset.serial.SerialBlob;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;

public class DBRecord
implements Writable,
DBWritable,
Configurable,
DataSizeReporter {
    private StructuredRecord record;
    private Configuration conf;
    private long bytesWritten;
    private long bytesRead;
    private int[] columnTypes;

    public DBRecord(StructuredRecord record, int[] columnTypes) {
        this.record = record;
        this.columnTypes = columnTypes;
    }

    public DBRecord() {
    }

    public void readFields(DataInput in) throws IOException {
    }

    public StructuredRecord getRecord() {
        return this.record;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    public void readFields(ResultSet resultSet) throws SQLException {
        this.bytesRead = 0L;
        ResultSetMetaData metadata = resultSet.getMetaData();
        String outputSchemaString = this.conf.get("io.cdap.hydrator.db.override.schema", null);
        Schema outputSchema = null;
        if (!Strings.isNullOrEmpty((String)outputSchemaString)) {
            try {
                outputSchema = Schema.parseJson((String)outputSchemaString);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Unable to parse schema string '%s'.", outputSchemaString), e);
            }
        }
        List originalSchema = DBUtils.getOriginalSchema((ResultSet)resultSet, outputSchema);
        String patternToReplace = this.conf.get("io.cdap.plugin.db.pattern.replace");
        String replaceWith = this.conf.get("io.cdap.plugin.db.replace.with");
        HashMap<String, String> nameMap = new HashMap<String, String>();
        ArrayList<Schema.Field> newSchema = new ArrayList<Schema.Field>();
        for (Schema.Field field : originalSchema) {
            String newName = field.getName();
            if (patternToReplace != null) {
                newName = newName.replaceAll(patternToReplace, replaceWith == null ? "" : replaceWith);
            }
            nameMap.put(newName, field.getName());
            newSchema.add(Schema.Field.of((String)newName, (Schema)field.getSchema()));
        }
        List schemaFields = DBUtils.getSchemaFields((Schema)Schema.recordOf((String)"resultSet", newSchema), (String)this.conf.get("io.cdap.hydrator.db.override.schema"));
        Schema schema = Schema.recordOf((String)"dbRecord", (Iterable)schemaFields);
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)schema);
        for (int i = 0; i < schemaFields.size(); ++i) {
            Schema.Field field = (Schema.Field)schemaFields.get(i);
            int sqlType = metadata.getColumnType(i + 1);
            int sqlPrecision = metadata.getPrecision(i + 1);
            int sqlScale = metadata.getScale(i + 1);
            Schema outputFieldSchema = field.getSchema();
            outputFieldSchema = outputFieldSchema.isNullable() ? outputFieldSchema.getNonNullable() : outputFieldSchema;
            this.setField(resultSet, recordBuilder, field, sqlType, sqlPrecision, sqlScale, nameMap.getOrDefault(field.getName(), field.getName()), outputFieldSchema);
        }
        this.record = recordBuilder.build();
    }

    private void setField(ResultSet resultSet, StructuredRecord.Builder recordBuilder, Schema.Field field, int sqlType, int sqlPrecision, int sqlScale, String originalName, Schema outputFieldSchema) throws SQLException {
        Object o = DBUtils.transformValue((int)sqlType, (int)sqlPrecision, (int)sqlScale, (ResultSet)resultSet, (String)originalName, (Schema)outputFieldSchema);
        if (o instanceof Date) {
            this.bytesRead += 8L;
            recordBuilder.setDate(field.getName(), ((Date)o).toLocalDate());
        } else if (o instanceof Time) {
            this.bytesRead += 4L;
            recordBuilder.setTime(field.getName(), ((Time)o).toLocalTime());
        } else if (o instanceof Timestamp) {
            this.bytesRead += 8L;
            Instant instant = ((Timestamp)o).toInstant();
            recordBuilder.setTimestamp(field.getName(), instant.atZone(ZoneId.ofOffset("UTC", ZoneOffset.UTC)));
        } else if (o instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)o;
            this.bytesRead += (long)(decimal.unscaledValue().bitLength() / 8 + 4);
            recordBuilder.setDecimal(field.getName(), decimal);
        } else if (o instanceof BigInteger) {
            Schema schema = field.getSchema();
            BigInteger bigint = (BigInteger)o;
            if (schema.isNullable()) {
                schema = schema.getNonNullable();
            }
            if (schema.getType() == Schema.Type.LONG) {
                Long int2long = bigint.longValueExact();
                this.bytesRead += 8L;
                recordBuilder.set(field.getName(), (Object)int2long);
            } else {
                BigDecimal int2dec = new BigDecimal(bigint, 0);
                this.bytesRead += (long)(int2dec.unscaledValue().bitLength() / 8 + 4);
                recordBuilder.setDecimal(field.getName(), int2dec);
            }
        } else {
            if (o != null) {
                Schema schema = field.getSchema();
                if (schema.isNullable()) {
                    schema = schema.getNonNullable();
                }
                switch (schema.getType()) {
                    case INT: 
                    case BOOLEAN: {
                        this.bytesRead += 4L;
                        break;
                    }
                    case LONG: {
                        this.bytesRead += 8L;
                        break;
                    }
                    case DOUBLE: {
                        this.bytesRead += 8L;
                        break;
                    }
                    case FLOAT: {
                        this.bytesRead += 4L;
                        break;
                    }
                    case STRING: {
                        String value = (String)o;
                        if (schema.getLogicalType() == Schema.LogicalType.DATETIME) {
                            try {
                                LocalDateTime.parse(value);
                            }
                            catch (DateTimeParseException exception) {
                                throw new UnexpectedFormatException(String.format("Datetime field '%s' with value '%s' is not in ISO-8601 format.", field.getName(), value), (Throwable)exception);
                            }
                        }
                        this.bytesRead += (long)value.length();
                        break;
                    }
                    case BYTES: {
                        this.bytesRead += (long)((byte[])o).length;
                    }
                }
            }
            recordBuilder.set(field.getName(), o);
        }
    }

    public void write(DataOutput out) throws IOException {
        Schema recordSchema = this.record.getSchema();
        List schemaFields = recordSchema.getFields();
        for (Schema.Field field : schemaFields) {
            this.writeToDataOut(out, field);
        }
    }

    public void write(PreparedStatement stmt) throws SQLException {
        this.bytesWritten = 0L;
        Schema recordSchema = this.record.getSchema();
        List schemaFields = recordSchema.getFields();
        for (int i = 0; i < schemaFields.size(); ++i) {
            this.writeToDB(stmt, (Schema.Field)schemaFields.get(i), i);
        }
    }

    private Schema getNonNullableSchema(Schema.Field field) {
        Schema schema = field.getSchema();
        if (field.getSchema().isNullable()) {
            schema = field.getSchema().getNonNullable();
        }
        Preconditions.checkArgument((boolean)schema.getType().isSimpleType(), (String)"Only simple types are supported (boolean, int, long, float, double, string, bytes) for writing a DBRecord, but found '%s' as the type for column '%s'. Please remove this column or transform it to a simple type.", (Object[])new Object[]{schema.getType(), field.getName()});
        return schema;
    }

    private void writeToDataOut(DataOutput out, Schema.Field field) throws IOException {
        Schema fieldSchema = this.getNonNullableSchema(field);
        Schema.Type fieldType = fieldSchema.getType();
        Object fieldValue = this.record.get(field.getName());
        if (fieldValue == null) {
            return;
        }
        switch (fieldType) {
            case NULL: {
                break;
            }
            case STRING: {
                out.writeUTF((String)fieldValue);
                break;
            }
            case BOOLEAN: {
                out.writeBoolean((Boolean)fieldValue);
                break;
            }
            case INT: {
                out.writeInt((Integer)fieldValue);
                break;
            }
            case LONG: {
                out.writeLong((Long)fieldValue);
                break;
            }
            case FLOAT: {
                out.writeFloat(((Float)fieldValue).floatValue());
                break;
            }
            case DOUBLE: {
                out.writeDouble((Double)fieldValue);
                break;
            }
            case BYTES: {
                out.write((byte[])fieldValue);
                break;
            }
            default: {
                throw new IOException(String.format("Column %s with value %s has an unsupported datatype %s", field.getName(), fieldValue, fieldType));
            }
        }
    }

    private void writeToDB(PreparedStatement stmt, Schema.Field field, int fieldIndex) throws SQLException {
        String fieldName = field.getName();
        Schema fieldSchema = this.getNonNullableSchema(field);
        Schema.Type fieldType = fieldSchema.getType();
        Schema.LogicalType fieldLogicalType = fieldSchema.getLogicalType();
        Object fieldValue = this.record.get(fieldName);
        int sqlIndex = fieldIndex + 1;
        if (fieldValue == null) {
            stmt.setNull(sqlIndex, this.columnTypes[fieldIndex]);
            return;
        }
        if (fieldLogicalType != null) {
            switch (fieldLogicalType) {
                case DATE: {
                    stmt.setDate(sqlIndex, Date.valueOf(this.record.getDate(fieldName)));
                    this.bytesWritten += 8L;
                    break;
                }
                case TIME_MILLIS: {
                    stmt.setTime(sqlIndex, Time.valueOf(this.record.getTime(fieldName)));
                    this.bytesWritten += 4L;
                    break;
                }
                case TIME_MICROS: {
                    stmt.setTime(sqlIndex, Time.valueOf(this.record.getTime(fieldName)));
                    this.bytesWritten += 8L;
                    break;
                }
                case TIMESTAMP_MILLIS: 
                case TIMESTAMP_MICROS: {
                    stmt.setTimestamp(sqlIndex, Timestamp.from(this.record.getTimestamp(fieldName).toInstant()));
                    this.bytesWritten += 8L;
                    break;
                }
                case DECIMAL: {
                    BigDecimal value = this.record.getDecimal(fieldName);
                    stmt.setBigDecimal(sqlIndex, value);
                    this.bytesWritten += (long)(value.unscaledValue().bitLength() / 8 + 4);
                    break;
                }
                case DATETIME: {
                    stmt.setString(sqlIndex, (String)fieldValue);
                    this.bytesWritten += (long)((String)fieldValue).length();
                }
            }
            return;
        }
        switch (fieldType) {
            case NULL: {
                stmt.setNull(sqlIndex, this.columnTypes[fieldIndex]);
                break;
            }
            case STRING: {
                stmt.setString(sqlIndex, (String)fieldValue);
                this.bytesWritten += (long)((String)fieldValue).length();
                break;
            }
            case BOOLEAN: {
                stmt.setBoolean(sqlIndex, (Boolean)fieldValue);
                this.bytesWritten += 4L;
                break;
            }
            case INT: {
                this.writeInt(stmt, fieldIndex, sqlIndex, fieldValue);
                this.bytesWritten += 4L;
                break;
            }
            case LONG: {
                stmt.setLong(sqlIndex, (Long)fieldValue);
                this.bytesWritten += 8L;
                break;
            }
            case FLOAT: {
                stmt.setFloat(sqlIndex, ((Float)fieldValue).floatValue());
                this.bytesWritten += 4L;
                break;
            }
            case DOUBLE: {
                stmt.setDouble(sqlIndex, (Double)fieldValue);
                this.bytesWritten += 8L;
                break;
            }
            case BYTES: {
                this.bytesWritten += (long)this.writeBytes(stmt, fieldIndex, sqlIndex, fieldValue);
                break;
            }
            default: {
                throw new SQLException(String.format("Column %s with value %s has an unsupported datatype %s", field.getName(), fieldValue, fieldType));
            }
        }
    }

    private int writeBytes(PreparedStatement stmt, int fieldIndex, int sqlIndex, Object fieldValue) throws SQLException {
        byte[] byteValue = fieldValue instanceof ByteBuffer ? Bytes.toBytes((ByteBuffer)((ByteBuffer)fieldValue)) : (byte[])fieldValue;
        int parameterType = this.columnTypes[fieldIndex];
        if (2004 == parameterType) {
            stmt.setBlob(sqlIndex, new SerialBlob(byteValue));
            return byteValue.length;
        }
        stmt.setBytes(sqlIndex, byteValue);
        return byteValue.length;
    }

    private void writeInt(PreparedStatement stmt, int fieldIndex, int sqlIndex, Object fieldValue) throws SQLException {
        Integer intValue = (Integer)fieldValue;
        int parameterType = this.columnTypes[fieldIndex];
        if (-6 == parameterType || 5 == parameterType) {
            stmt.setShort(sqlIndex, intValue.shortValue());
            return;
        }
        stmt.setInt(sqlIndex, intValue);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }
}

