/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin;

import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.plugin.FieldCase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class StructuredRecordUtils {
    public static StructuredRecord convertCase(StructuredRecord input, FieldCase fieldCase) throws Exception {
        if (fieldCase.equals((Object)FieldCase.NONE)) {
            return input;
        }
        Schema oldSchema = input.getSchema();
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        ArrayList<Schema.Field> newFields = new ArrayList<Schema.Field>();
        for (Schema.Field field : oldSchema.getFields()) {
            String newName = StructuredRecordUtils.changeName(field.getName(), fieldCase);
            if (fieldNameMap.containsValue(newName)) {
                throw new IllegalStateException(String.format("Duplicate field/column name %s found when trying to confirm to the chosen case option %s. Check Database Table schema.", new Object[]{field.getName(), fieldCase}));
            }
            fieldNameMap.put(field.getName(), newName);
            newFields.add(Schema.Field.of((String)newName, (Schema)field.getSchema()));
        }
        StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)Schema.recordOf((String)"dbRecord", newFields));
        for (Map.Entry nameMap : fieldNameMap.entrySet()) {
            recordBuilder.set((String)nameMap.getValue(), input.get((String)nameMap.getKey()));
        }
        return recordBuilder.build();
    }

    private StructuredRecordUtils() {
    }

    private static String changeName(String oldName, FieldCase fieldCase) {
        switch (fieldCase) {
            case LOWER: {
                return oldName.toLowerCase();
            }
            case UPPER: {
                return oldName.toUpperCase();
            }
        }
        return oldName;
    }
}

