/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch;

import io.cdap.cdap.etl.api.FailureCollector;
import java.util.Arrays;
import javax.annotation.Nullable;

public final class TransactionIsolationLevel {
    public static final String CONF_KEY = "io.cdap.hydrator.db.plugin.transaction.isolation.level";

    private TransactionIsolationLevel() {
    }

    public static int getLevel(@Nullable String level) {
        if (level == null) {
            return 8;
        }
        return Level.valueOf(level.toUpperCase()).level;
    }

    public static void validate(@Nullable String level, FailureCollector collector) {
        if (level == null) {
            return;
        }
        try {
            Level.valueOf(level.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            collector.addFailure("Unsupported Transaction Isolation Level.", String.format("Transaction Isolation Level must be one of the following values: %s", Arrays.toString((Object[])Level.values()))).withConfigProperty("transactionIsolationLevel");
        }
    }

    public static enum Level {
        TRANSACTION_NONE(0),
        TRANSACTION_READ_UNCOMMITTED(1),
        TRANSACTION_READ_COMMITTED(2),
        TRANSACTION_REPEATABLE_READ(4),
        TRANSACTION_SERIALIZABLE(8);

        private final int level;

        private Level(int level) {
            this.level = level;
        }
    }
}

