/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.action;

import io.cdap.plugin.DBManager;
import io.cdap.plugin.db.batch.action.QueryConfig;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;

public class DBRun {
    private final QueryConfig config;
    private final Class<? extends Driver> driverClass;

    public DBRun(QueryConfig config, Class<? extends Driver> driverClass) {
        this.config = config;
        this.driverClass = driverClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws SQLException, InstantiationException, IllegalAccessException {
        DBManager dbManager = new DBManager(this.config);
        try {
            dbManager.ensureJDBCDriverIsAvailable(this.driverClass);
            try (Connection connection = this.getConnection();){
                if (!this.config.enableAutoCommit.booleanValue()) {
                    connection.setAutoCommit(false);
                }
                try (Statement statement = connection.createStatement();){
                    statement.execute(this.config.query);
                    if (!this.config.enableAutoCommit.booleanValue()) {
                        connection.commit();
                    }
                }
            }
        }
        finally {
            dbManager.destroy();
        }
    }

    private Connection getConnection() throws SQLException {
        return DriverManager.getConnection(this.config.connectionString, this.config.getConnectionArguments());
    }
}

