/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.sink;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.cdap.plugin.ConnectionConfig;
import io.cdap.plugin.DataSizeReporter;
import io.cdap.plugin.common.db.DBUtils;
import io.cdap.plugin.common.db.JDBCDriverShim;
import io.cdap.plugin.db.batch.NoOpCommitConnection;
import io.cdap.plugin.db.batch.TransactionIsolationLevel;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBOutputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormatCounter;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ETLDBOutputFormat<K extends DBWritable, V>
extends DBOutputFormat<K, V> {
    public static final String AUTO_COMMIT_ENABLED = "io.cdap.hydrator.db.output.autocommit.enabled";
    public static final String COMMIT_BATCH_SIZE = "io.cdap.plugin.db.output.commit.batch.size";
    public static final int DEFAULT_COMMIT_BATCH_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(ETLDBOutputFormat.class);
    private Configuration conf;
    private Driver driver;
    private JDBCDriverShim driverShim;

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException {
        this.conf = context.getConfiguration();
        DBConfiguration dbConf = new DBConfiguration(this.conf);
        String tableName = dbConf.getOutputTableName();
        String[] fieldNames = dbConf.getOutputFieldNames();
        final int batchSize = this.conf.getInt(COMMIT_BATCH_SIZE, 1000);
        if (fieldNames == null) {
            fieldNames = new String[dbConf.getOutputFieldCount()];
        }
        try {
            Connection connection = this.getConnection(this.conf);
            PreparedStatement statement = connection.prepareStatement(this.constructQuery(tableName, fieldNames));
            return new DBOutputFormat.DBRecordWriter(connection, statement){
                private boolean emptyData;
                private long bytesWritten;
                private long recordsWritten;
                {
                    super((DBOutputFormat)ETLDBOutputFormat.this, x0, x1);
                    this.emptyData = true;
                    this.bytesWritten = 0L;
                    this.recordsWritten = 0L;
                }

                public void close(TaskAttemptContext context) throws IOException {
                    try {
                        if (!this.emptyData) {
                            this.getStatement().executeBatch();
                            this.getConnection().commit();
                            context.getCounter((Enum)FileOutputFormatCounter.BYTES_WRITTEN).increment(this.bytesWritten);
                        }
                    }
                    catch (SQLException e) {
                        try {
                            this.getConnection().rollback();
                        }
                        catch (SQLException ex) {
                            LOG.warn(StringUtils.stringifyException((Throwable)ex));
                        }
                        throw new IOException(e);
                    }
                    finally {
                        try {
                            this.getStatement().close();
                            this.getConnection().close();
                        }
                        catch (SQLException ex) {
                            throw new IOException(ex);
                        }
                    }
                    try {
                        DriverManager.deregisterDriver((Driver)ETLDBOutputFormat.this.driverShim);
                    }
                    catch (SQLException e) {
                        throw new IOException(e);
                    }
                }

                public void write(K key, V value) throws IOException {
                    super.write(key, value);
                    if (key instanceof DataSizeReporter) {
                        this.bytesWritten += ((DataSizeReporter)key).getBytesWritten();
                    }
                    if (value instanceof DataSizeReporter) {
                        this.bytesWritten += ((DataSizeReporter)value).getBytesWritten();
                    }
                    ++this.recordsWritten;
                    try {
                        if (batchSize > 0 && this.recordsWritten % (long)batchSize == 0L) {
                            this.getStatement().executeBatch();
                        }
                    }
                    catch (SQLException e) {
                        try {
                            this.getConnection().rollback();
                        }
                        catch (SQLException ex) {
                            LOG.warn(StringUtils.stringifyException((Throwable)ex));
                        }
                        throw new IOException(e);
                    }
                    this.emptyData = false;
                }
            };
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private Connection getConnection(Configuration conf) {
        Connection connection;
        try {
            String url;
            block7: {
                url = conf.get("mapreduce.jdbc.url");
                try {
                    DriverManager.getDriver(url);
                }
                catch (SQLException e) {
                    if (this.driverShim != null) break block7;
                    if (this.driver == null) {
                        ClassLoader classLoader = conf.getClassLoader();
                        Class<?> driverClass = classLoader.loadClass(conf.get("mapreduce.jdbc.driver.class"));
                        this.driver = (Driver)driverClass.newInstance();
                        DBUtils.deregisterAllDrivers(driverClass);
                    }
                    this.driverShim = new JDBCDriverShim(this.driver);
                    DriverManager.registerDriver((Driver)this.driverShim);
                    LOG.debug("Registered JDBC driver via shim {}. Actual Driver {}.", (Object)this.driverShim, (Object)this.driver);
                }
            }
            Properties properties = ConnectionConfig.getConnectionArguments(conf.get("io.cdap.hydrator.db.connection.arguments"), conf.get("mapreduce.jdbc.username"), conf.get("mapreduce.jdbc.password"));
            connection = DriverManager.getConnection(url, properties);
            boolean autoCommitEnabled = conf.getBoolean(AUTO_COMMIT_ENABLED, false);
            if (autoCommitEnabled) {
                connection = new NoOpCommitConnection(connection);
            } else {
                connection.setAutoCommit(false);
            }
            String level = conf.get("io.cdap.hydrator.db.plugin.transaction.isolation.level");
            LOG.debug("Transaction isolation level: {}", (Object)level);
            connection.setTransactionIsolation(TransactionIsolationLevel.getLevel(level));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
        return connection;
    }

    public String constructQuery(String table, String[] fieldNames) {
        String query = super.constructQuery(table, fieldNames);
        query = query.substring(0, query.length() - 1);
        String urlProperty = this.conf.get("mapreduce.jdbc.url");
        if (urlProperty.startsWith("jdbc:phoenix")) {
            LOG.debug("Phoenix jdbc connection detected. Replacing INSERT with UPSERT.");
            Preconditions.checkArgument((boolean)query.startsWith("INSERT"), (Object)"Expecting query to start with 'INSERT'");
            query = "UPSERT" + query.substring("INSERT".length());
        }
        return query;
    }
}

