/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.batch.source;

import com.google.common.base.Throwables;
import io.cdap.plugin.ConnectionConfig;
import io.cdap.plugin.DataSizeReporter;
import io.cdap.plugin.common.db.DBUtils;
import io.cdap.plugin.common.db.JDBCDriverShim;
import io.cdap.plugin.db.batch.NoOpCommitConnection;
import io.cdap.plugin.db.batch.TransactionIsolationLevel;
import io.cdap.plugin.db.batch.source.ConnectionWithFetchSize;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.db.DBConfiguration;
import org.apache.hadoop.mapreduce.lib.db.DBInputFormat;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormatCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataDrivenETLDBInputFormat
extends DataDrivenDBInputFormat {
    public static final String AUTO_COMMIT_ENABLED = "io.cdap.hydrator.db.autocommit.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(DataDrivenETLDBInputFormat.class);
    private Driver driver;
    private JDBCDriverShim driverShim;

    static void setInput(Configuration conf, Class<? extends DBWritable> inputClass, String inputQuery, String inputBoundingQuery, boolean enableAutoCommit) {
        DBConfiguration dbConf = new DBConfiguration(conf);
        dbConf.setInputClass(inputClass);
        dbConf.setInputQuery(inputQuery);
        dbConf.setInputBoundingQuery(inputBoundingQuery);
        conf.setBoolean(AUTO_COMMIT_ENABLED, enableAutoCommit);
    }

    public Connection getConnection() {
        if (this.connection == null) {
            Configuration conf = this.getConf();
            try {
                String url;
                block9: {
                    url = conf.get("mapreduce.jdbc.url");
                    try {
                        DriverManager.getDriver(url);
                    }
                    catch (SQLException e) {
                        if (this.driverShim != null) break block9;
                        if (this.driver == null) {
                            ClassLoader classLoader = conf.getClassLoader();
                            Class<?> driverClass = classLoader.loadClass(conf.get("mapreduce.jdbc.driver.class"));
                            this.driver = (Driver)driverClass.newInstance();
                            DBUtils.deregisterAllDrivers(driverClass);
                        }
                        this.driverShim = new JDBCDriverShim(this.driver);
                        DriverManager.registerDriver((Driver)this.driverShim);
                        LOG.debug("Registered JDBC driver via shim {}. Actual Driver {}.", (Object)this.driverShim, (Object)this.driver);
                    }
                }
                Properties properties = ConnectionConfig.getConnectionArguments(conf.get("io.cdap.hydrator.db.connection.arguments"), conf.get("mapreduce.jdbc.username"), conf.get("mapreduce.jdbc.password"));
                this.connection = DriverManager.getConnection(url, properties);
                boolean autoCommitEnabled = conf.getBoolean(AUTO_COMMIT_ENABLED, false);
                if (autoCommitEnabled) {
                    this.connection = new NoOpCommitConnection(this.connection);
                } else {
                    this.connection.setAutoCommit(false);
                }
                int fetchSize = conf.getInt("io.cdap.hydrator.db.fetch.size", 0);
                if (fetchSize > 0) {
                    this.connection = new ConnectionWithFetchSize(this.connection, fetchSize);
                }
                String level = conf.get("io.cdap.hydrator.db.plugin.transaction.isolation.level");
                LOG.debug("Transaction isolation level: {}", (Object)level);
                this.connection.setTransactionIsolation(TransactionIsolationLevel.getLevel(level));
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return this.connection;
    }

    public Connection createConnection() {
        return this.getConnection();
    }

    protected RecordReader createDBRecordReader(DBInputFormat.DBInputSplit split, Configuration conf) throws IOException {
        final RecordReader dbRecordReader = super.createDBRecordReader(split, conf);
        return new RecordReader(){
            private long bytesRead = 0L;
            private TaskAttemptContext taskAttemptContext;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                dbRecordReader.initialize(split, context);
                this.taskAttemptContext = context;
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return dbRecordReader.nextKeyValue();
            }

            public Object getCurrentKey() throws IOException, InterruptedException {
                Object key = dbRecordReader.getCurrentKey();
                if (key instanceof DataSizeReporter) {
                    this.bytesRead += ((DataSizeReporter)key).getBytesRead();
                }
                return key;
            }

            public Object getCurrentValue() throws IOException, InterruptedException {
                Object value = dbRecordReader.getCurrentValue();
                if (value instanceof DataSizeReporter) {
                    this.bytesRead += ((DataSizeReporter)value).getBytesRead();
                }
                return value;
            }

            public float getProgress() throws IOException, InterruptedException {
                return dbRecordReader.getProgress();
            }

            public void close() throws IOException {
                dbRecordReader.close();
                this.taskAttemptContext.getCounter((Enum)FileInputFormatCounter.BYTES_READ).increment(this.bytesRead);
                try {
                    DriverManager.deregisterDriver((Driver)DataDrivenETLDBInputFormat.this.driverShim);
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    protected void closeConnection() {
        super.closeConnection();
        try {
            DriverManager.deregisterDriver((Driver)this.driverShim);
        }
        catch (SQLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

