/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.common;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.plugin.db.connector.DBConnectorConfig;
import java.util.Properties;
import javax.annotation.Nullable;

public class DBBaseConfig
extends PluginConfig {
    public static final String COLUMN_NAME_CASE = "columnNameCase";
    public static final String ENABLE_AUTO_COMMIT = "enableAutoCommit";
    public static final String NAME_USE_CONNECTION = "useConnection";
    public static final String NAME_CONNECTION = "connection";
    public static final String JDBC_PLUGIN_TYPE = "jdbcPluginType";
    @Name(value="referenceName")
    @Description(value="This will be used to uniquely identify this source/sink for lineage, annotating metadata, etc.")
    private String referenceName;
    @Name(value="columnNameCase")
    @Description(value="Sets the case of the column names returned from the query. Possible options are upper or lower. By default or for any other input, the column names are not modified and the names returned from the database are used as-is. Note that setting this property provides predictability of column name cases across different databases but might result in column name conflicts if multiple column names are the same when the case is ignored.")
    @Nullable
    @Macro
    private String columnNameCase;
    @Name(value="enableAutoCommit")
    @Description(value="Whether to enable auto commit for queries run by this source. Defaults to false. This setting should only matter if you are using a jdbc driver that does not support a false value for auto commit, or a driver that does not support the commit call. For example, the Hive jdbc driver will throw an exception whenever a commit is called. For drivers like that, this should be set to true.")
    @Nullable
    private Boolean enableAutoCommit;
    @Name(value="useConnection")
    @Nullable
    @Description(value="Whether to use an existing connection.")
    private Boolean useConnection;
    @Name(value="connection")
    @Macro
    @Nullable
    @Description(value="The existing connection to use.")
    private DBConnectorConfig connection;
    @Name(value="jdbcPluginType")
    @Description(value="Type of the JDBC plugin to use. This is the value of the 'type' key defined in the JSON file for the JDBC plugin. Defaults to 'jdbc'.")
    @Nullable
    public String jdbcPluginType;

    public boolean getEnableAutoCommit() {
        return this.enableAutoCommit == null ? false : this.enableAutoCommit;
    }

    public String getJdbcPluginType() {
        return this.jdbcPluginType == null ? "jdbc" : this.jdbcPluginType;
    }

    @Nullable
    protected String cleanQuery(@Nullable String query) {
        if (query == null) {
            return null;
        }
        if ((query = query.trim()).isEmpty()) {
            return query;
        }
        int idx = query.length() - 1;
        char currChar = query.charAt(idx);
        while (idx > 0 && currChar == ';' || Character.isWhitespace(currChar)) {
            currChar = query.charAt(--idx);
        }
        if (idx == 0) {
            return "";
        }
        return query.substring(0, idx + 1);
    }

    public String getJdbcPluginName() {
        return this.connection.getJdbcPluginName();
    }

    public Properties getAllConnectionArguments() {
        return this.connection.getConnectionArgumentsProperties();
    }

    public String getConnectionArguments() {
        return this.connection.getConnectionArguments();
    }

    public String getConnectionString() {
        return this.connection.getConnectionString();
    }

    @Nullable
    public String getUser() {
        return this.connection.getUser();
    }

    @Nullable
    public String getPassword() {
        return this.connection.getPassword();
    }

    public DBConnectorConfig getConnection() {
        return this.connection;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public String getColumnNameCase() {
        return this.columnNameCase;
    }
}

