/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.connector;

import io.cdap.cdap.api.annotation.Category;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.format.UnexpectedFormatException;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.cdap.etl.api.connector.ConnectorContext;
import io.cdap.cdap.etl.api.connector.ConnectorSpec;
import io.cdap.cdap.etl.api.connector.ConnectorSpecRequest;
import io.cdap.cdap.etl.api.connector.DirectConnector;
import io.cdap.cdap.etl.api.connector.PluginSpec;
import io.cdap.cdap.etl.api.connector.SampleRequest;
import io.cdap.plugin.common.db.AbstractDBConnector;
import io.cdap.plugin.common.db.DBConnectorPath;
import io.cdap.plugin.common.db.DBPath;
import io.cdap.plugin.common.db.DBUtils;
import io.cdap.plugin.db.connector.DBConnectorConfig;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;

@Plugin(type="connector")
@Name(value="Database")
@Description(value="Connection to access data in relational databases using JDBC.")
@Category(value="Database")
public class DBConnector
extends AbstractDBConnector<DBConnectorConfig>
implements DirectConnector {
    public static final String NAME = "Database";
    private final DBConnectorConfig config;

    public DBConnector(DBConnectorConfig config) {
        super((PluginConfig)config);
        this.config = config;
    }

    protected DBConnectorPath getDBConnectorPath(String path) throws IOException {
        try {
            return new DBPath(path, this.getConnection().getMetaData().supportsSchemasInTableDefinitions());
        }
        catch (SQLException e) {
            throw new IOException(String.format("Failed to parse the path %s for the connector", path), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<StructuredRecord> sample(ConnectorContext context, SampleRequest sampleRequest) throws IOException {
        try (Connection connection = this.getConnection();){
            DBPath path = new DBPath(sampleRequest.getPath(), connection.getMetaData().supportsSchemasInTableDefinitions());
            String table = path.getTable();
            if (table == null) {
                throw new IllegalArgumentException("Path should contain table name.");
            }
            String schema = path.getSchema();
            List<StructuredRecord> list = this.getTableData(connection, schema, table, sampleRequest.getLimit());
            return list;
        }
        catch (SQLException e) {
            throw new IOException("Failed to sample.", e);
        }
    }

    protected void setConnectorSpec(ConnectorSpecRequest request, DBConnectorPath path, ConnectorSpec.Builder builder) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("useConnection", "true");
        properties.put("connection", request.getConnectionWithMacro());
        properties.put("jdbcPluginType", "jdbc");
        if (path.getTable() != null) {
            properties.put("referenceName", path.getTable());
        }
        builder.addRelatedPlugin(new PluginSpec(NAME, "batchsource", properties)).addRelatedPlugin(new PluginSpec(NAME, "batchsink", properties));
        String table = path.getTable();
        if (table == null) {
            return;
        }
        String schema = path.getSchema();
        properties.put("importQuery", schema == null ? String.format("SELECT * FROM %s;", table) : String.format("SELECT * FROM %s.%s;", schema, table));
        properties.put("numSplits", "1");
    }

    /*
     * Exception decompiling
     */
    private List<StructuredRecord> getTableData(Connection connection, @Nullable String schema, String table, int limit) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<StructuredRecord> parseResultSet(ResultSet resultSet, int limit) throws SQLException {
        ArrayList<StructuredRecord> result = new ArrayList<StructuredRecord>();
        Schema schema = Schema.recordOf((String)"output", (Iterable)DBUtils.getSchemaFields((ResultSet)resultSet, null, null, null));
        ResultSetMetaData meta = resultSet.getMetaData();
        for (int count = 0; resultSet.next() && count < limit; ++count) {
            StructuredRecord.Builder recordBuilder = StructuredRecord.builder((Schema)schema);
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                Schema fieldSchema;
                int sqlScale;
                int sqlPrecision;
                String fieldName = meta.getColumnName(i);
                int sqlType = meta.getColumnType(i);
                Object value = DBUtils.transformValue((int)sqlType, (int)(sqlPrecision = meta.getPrecision(i)), (int)(sqlScale = meta.getScale(i)), (ResultSet)resultSet, (String)fieldName, (Schema)(fieldSchema = (fieldSchema = schema.getField(fieldName).getSchema()).isNullable() ? fieldSchema.getNonNullable() : fieldSchema));
                if (value instanceof Date) {
                    recordBuilder.setDate(fieldName, ((Date)value).toLocalDate());
                    continue;
                }
                if (value instanceof Time) {
                    recordBuilder.setTime(fieldName, ((Time)value).toLocalTime());
                    continue;
                }
                if (value instanceof Timestamp) {
                    recordBuilder.setTimestamp(fieldName, ((Timestamp)value).toInstant().atZone(ZoneId.ofOffset("UTC", ZoneOffset.UTC)));
                    continue;
                }
                if (value instanceof BigDecimal) {
                    recordBuilder.setDecimal(fieldName, (BigDecimal)value);
                    continue;
                }
                if (value instanceof String && fieldSchema.getLogicalType() == Schema.LogicalType.DATETIME) {
                    try {
                        recordBuilder.setDateTime(fieldName, LocalDateTime.parse((String)value));
                        continue;
                    }
                    catch (DateTimeParseException exception) {
                        throw new UnexpectedFormatException(String.format("Datetime field '%s' with value '%s' is not in ISO-8601 format.", fieldName, value), (Throwable)exception);
                    }
                }
                recordBuilder.set(fieldName, value);
            }
            result.add(recordBuilder.build());
        }
        return result;
    }
}

