/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.db.connector;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Macro;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.dataset.lib.KeyValue;
import io.cdap.cdap.api.plugin.PluginConfig;
import io.cdap.plugin.common.KeyValueListParser;
import io.cdap.plugin.common.db.DBConnectorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;

public class DBConnectorConfig
extends PluginConfig
implements DBConnectorProperties {
    public static final String CONNECTION_STRING = "connectionString";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String CONNECTION_ARGUMENTS = "connectionArguments";
    public static final String JDBC_PLUGIN_NAME = "jdbcPluginName";
    @Name(value="connectionString")
    @Description(value="JDBC connection string. Must include database name.")
    @Macro
    private String connectionString;
    @Name(value="user")
    @Description(value="User to use to connect to the specified database. Required for databases that need authentication. Optional for databases that do not require authentication.")
    @Nullable
    @Macro
    private String user;
    @Name(value="password")
    @Description(value="Password to use to connect to the specified database. Required for databases that need authentication. Optional for databases that do not require authentication.")
    @Nullable
    @Macro
    private String password;
    @Name(value="connectionArguments")
    @Description(value="A list of arbitrary string tag/value pairs as connection arguments. This is a semicolon-separated list of key-value pairs, where each pair is separated by a equals '=' and specifies the key and value for the argument. For example, 'key1=value1;key2=value' specifies that the connection will be given arguments 'key1' mapped to 'value1' and the argument 'key2' mapped to 'value2'.")
    @Nullable
    @Macro
    private String connectionArguments;
    @Name(value="jdbcPluginName")
    @Description(value="Name of the JDBC plugin to use. This is the value of the 'name' key defined in the JSON file for the JDBC plugin.")
    @Macro
    private String jdbcPluginName;

    public DBConnectorConfig(String user, String password, String jdbcPluginName, String connectionString, String connectionArguments) {
        this.user = user;
        this.password = password;
        this.jdbcPluginName = jdbcPluginName;
        this.connectionString = connectionString;
        this.connectionArguments = connectionArguments;
    }

    public static Properties getConnectionArgumentsProperties(@Nullable String connectionArguments, @Nullable String user, @Nullable String password) {
        KeyValueListParser kvParser = new KeyValueListParser("\\s*;\\s*", "=");
        HashMap<Object, Object> connectionArgumentsMap = new HashMap<Object, Object>();
        if (!Strings.isNullOrEmpty((String)connectionArguments)) {
            for (KeyValue keyVal : kvParser.parse(connectionArguments)) {
                connectionArgumentsMap.put(keyVal.getKey(), keyVal.getValue());
            }
        }
        if (user != null) {
            connectionArgumentsMap.put(USER, user);
        }
        if (password != null) {
            connectionArgumentsMap.put(PASSWORD, password);
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)connectionArgumentsMap);
        return properties;
    }

    public Properties getConnectionArgumentsProperties() {
        return DBConnectorConfig.getConnectionArgumentsProperties(this.connectionArguments, this.user, this.password);
    }

    public String getConnectionArguments() {
        return this.connectionArguments;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public String getJdbcPluginName() {
        return this.jdbcPluginName;
    }
}

