package io.contextmap.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * Annotation used to define a term for the glossary
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextGlossary {

    /**
     * By default the class's simple name will be used.
     * Use this property to override this default.
     * @return the name of the term
     */
    String name() default "";

    /**
     * Definition explaining the term.
     * @return the definition of the term
     */
    String definition() default "";

    /**
     * List of possible aliases.
     * @return possible aliases of the term
     */
    String[] aliases() default {};


}
