package io.contextmap.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to mark payloads for events.
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextEvent {

    /**
     * List of names or SpringBean-names on which the event is published.
     * If the event is published to multiple location, then you can provide multiple bean-names.
     *
     * e.g. for RabbitMQ this can be the bean-name of an Exchange, or the bean-name of a RabbitTemplate.
     * e.g. for ActiveMQ (JMS) this can be the bean-name of a Queue, or the bean-name of a Topic, or the actual name.
     *
     * @return names of the SpringBeans
     */
    String[] publishedBy() default {};

}
