package io.contextmap.annotations.capability;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation used to mark a business capability
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ContextCapability {

    /**
     * Name of the capability.
     * @return the name of the capability
     */
    String value() default "";

}
