/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.ReflectionService;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.DomainObject;
import io.contextmap.model.Field;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EntityService {
    private static final String[] classesUsedByEntities = new String[]{"javax.persistence.Entity", "javax.persistence.MappedSuperclass", "org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document", "org.springframework.data.solr.core.mapping.SolrDocument", "org.springframework.data.couchbase.core.mapping.Document", "org.springframework.data.redis.core.RedisHash", "org.springframework.data.cassandra.core.mapping.Table", "org.springframework.data.neo4j.core.schema.Node", "io.contextmap.annotations.ContextAggregateRoot", "io.contextmap.annotations.ContextEntity"};
    private static final String[] classesUsedByEntitiesWhereFieldsAreAutomaticallyEntities = new String[]{"org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document", "org.springframework.data.solr.core.mapping.SolrDocument", "org.springframework.data.couchbase.core.mapping.Document"};
    private static final Set<String> classesSeenAsAggregateRoot = new HashSet<String>(Arrays.asList("io.contextmap.annotations.ContextAggregateRoot", "org.springframework.data.mongodb.core.mapping.Document", "org.springframework.data.elasticsearch.annotations.Document", "org.springframework.data.solr.core.mapping.SolrDocument", "org.springframework.data.couchbase.core.mapping.Document"));
    private final ReflectionService reflectionService;

    public EntityService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<DomainObject> scan() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedByEntities);
            return this.scanClasses(classes);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for entities");
            return Collections.emptyList();
        }
    }

    List<DomainObject> scanClasses(Collection<Class<?>> classes) {
        Set allEntityFullyQualifiedNames = classes.stream().map(Class::getName).collect(Collectors.toSet());
        return classes.stream().map(type -> this.toEntity((Class<?>)type, allEntityFullyQualifiedNames)).collect(Collectors.toList());
    }

    private DomainObject toEntity(Class<?> type, Set<String> allEntityFullyQualifiedNames) {
        DomainObject entity = new DomainObject();
        entity.name = type.getSimpleName();
        entity.fullyQualifiedName = type.getName();
        entity.aggregateRoot = this.isAggregateRoot(type);
        List fieldDescriptors = Arrays.stream(type.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).map(this::toFieldDescriptor).collect(Collectors.toList());
        entity.fields = fieldDescriptors.stream().map(FieldDescriptor::getField).collect(Collectors.toList());
        ArrayList dependencies = new ArrayList(entity.fields.stream().map(f -> f.typeFullyQualifiedName).filter(allEntityFullyQualifiedNames::contains).collect(Collectors.toList()));
        dependencies.addAll(fieldDescriptors.stream().flatMap(fd -> fd.getParameterClasses().stream()).map(Class::getName).filter(allEntityFullyQualifiedNames::contains).collect(Collectors.toList()));
        this.getBaseClass(type).ifPresent(baseClass -> {
            String baseClassFQN = baseClass.getName();
            if (allEntityFullyQualifiedNames.contains(baseClassFQN)) {
                dependencies.add(baseClassFQN);
                entity.baseTypeNames = Collections.singletonList(baseClass.getSimpleName());
            }
        });
        this.getImplementedInterfaces(type).forEach(interfaceClass -> {
            String interfaceClassFQN = interfaceClass.getName();
            if (allEntityFullyQualifiedNames.contains(interfaceClassFQN)) {
                dependencies.add(interfaceClassFQN);
                if (entity.implementationTypeNames == null) {
                    entity.implementationTypeNames = new ArrayList();
                }
                entity.implementationTypeNames.add(interfaceClass.getSimpleName());
            }
        });
        entity.dependsOnEntityFullyQualifiedNames = dependencies;
        return entity;
    }

    private boolean isAggregateRoot(Class<?> type) {
        Annotation[] annotations;
        for (Annotation ann : annotations = type.getAnnotations()) {
            String annotationFullyQualifiedName = ann.annotationType().getName();
            if (!classesSeenAsAggregateRoot.contains(annotationFullyQualifiedName)) continue;
            MojoLogger.logger.info("Found aggregate root " + type.getName());
            return true;
        }
        return false;
    }

    private List<Class<?>> getImplementedInterfaces(Class<?> type) {
        return Arrays.asList(type.getInterfaces());
    }

    private Optional<Class<?>> getBaseClass(Class<?> type) {
        Type baseType = type.getGenericSuperclass();
        if (baseType instanceof Class) {
            return Optional.of((Class)baseType);
        }
        if (baseType instanceof ParameterizedType && ((ParameterizedType)baseType).getRawType() instanceof Class) {
            return Optional.of((Class)((ParameterizedType)baseType).getRawType());
        }
        return Optional.empty();
    }

    private FieldDescriptor toFieldDescriptor(java.lang.reflect.Field f) {
        if (f.getGenericType() instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)f.getGenericType();
            Type[] parameterTypes = parameterizedType.getActualTypeArguments();
            ArrayList<Class<?>> parameterClasses = new ArrayList();
            if (parameterTypes != null) {
                parameterClasses = Arrays.stream(parameterTypes).filter(pt -> pt instanceof Class).map(pt -> (Class)pt).collect(Collectors.toList());
            }
            String parameterDescription = "<" + parameterClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(",")) + ">";
            Field field = new Field(f.getName(), f.getType().getSimpleName() + parameterDescription, f.getType().getName());
            return new FieldDescriptor(field, parameterClasses);
        }
        Field field = new Field(f.getName(), f.getType().getSimpleName(), f.getType().getName());
        return new FieldDescriptor(field);
    }

    private static class FieldDescriptor {
        private final Field field;
        private final List<Class<?>> parameterClasses;

        public FieldDescriptor(Field field) {
            this(field, Collections.emptyList());
        }

        public FieldDescriptor(Field field, List<Class<?>> parameterClasses) {
            this.field = field;
            this.parameterClasses = parameterClasses;
        }

        public Field getField() {
            return this.field;
        }

        public List<Class<?>> getParameterClasses() {
            return this.parameterClasses;
        }
    }
}

