/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.BytesOfCode;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.project.MavenProject;

public class LanguageService {
    private static List<Language> languages = Arrays.asList(new Language("Java", LanguageService.listOf(".java"), LanguageService.listOf(new String[0])), new Language("Kotlin", LanguageService.listOf(".kt", ".ktm", ".kts"), LanguageService.listOf(new String[0])), new Language("Scala", LanguageService.listOf(".scala", ".sc"), LanguageService.listOf(new String[0])), new Language("Scaml", LanguageService.listOf(".scaml"), LanguageService.listOf(new String[0])), new Language("Jasper Report", LanguageService.listOf(".jrxml", ".jrtx"), LanguageService.listOf(new String[0])), new Language("Javascript", LanguageService.listOf(".js"), LanguageService.listOf(new String[0])), new Language("Typescript", LanguageService.listOf(".ts", ".tsx"), LanguageService.listOf(new String[0])), new Language("Java Server Pages", LanguageService.listOf(".jsp"), LanguageService.listOf(new String[0])), new Language("Java Server Faces", LanguageService.listOf(".jsf", ".faces"), LanguageService.listOf(new String[0])), new Language("Groovy", LanguageService.listOf(".groovy"), LanguageService.listOf("Jenkinsfile")), new Language("Dockerfile", LanguageService.listOf(".dockerfile"), LanguageService.listOf("Dockerfile")), new Language("Yaml", LanguageService.listOf(".yml", ".yaml"), LanguageService.listOf(new String[0])), new Language("Text", LanguageService.listOf(".txt"), LanguageService.listOf(new String[0])), new Language("AsciiDoc", LanguageService.listOf(".asciidoc", ".adoc"), LanguageService.listOf(new String[0])), new Language("Markdown", LanguageService.listOf(".md", ".markdown", ".adr"), LanguageService.listOf(new String[0])), new Language("HTML", LanguageService.listOf(".html", ".htm", ".xhtml"), LanguageService.listOf(new String[0])), new Language("SQL", LanguageService.listOf(".sql", ".mysql"), LanguageService.listOf(new String[0])), new Language("PLSQL", LanguageService.listOf(".plsql", ".pkb", ".pks"), LanguageService.listOf(new String[0])), new Language("XML", LanguageService.listOf(".xml", ".wsdl"), LanguageService.listOf(".project", ".classpath")), new Language("XSLT", LanguageService.listOf(".xslt", ".xsl"), LanguageService.listOf(new String[0])), new Language("SVG", LanguageService.listOf(".svg"), LanguageService.listOf(new String[0])), new Language("CSS", LanguageService.listOf(".css"), LanguageService.listOf(new String[0])), new Language("SCSS", LanguageService.listOf(".scss"), LanguageService.listOf(new String[0])), new Language("Less", LanguageService.listOf(".less"), LanguageService.listOf(new String[0])), new Language("CSV", LanguageService.listOf(".csv"), LanguageService.listOf(new String[0])), new Language("Sass", LanguageService.listOf(".sass"), LanguageService.listOf(new String[0])), new Language("Batchfile", LanguageService.listOf(".bat", ".cmd"), LanguageService.listOf(new String[0])), new Language("Shell", LanguageService.listOf(".sh", ".bash", ".ksh", ".zsh"), LanguageService.listOf(new String[0])), new Language("Properties", LanguageService.listOf(".properties"), LanguageService.listOf(new String[0])), new Language("Maven POM", LanguageService.listOf(new String[0]), LanguageService.listOf("pom.xml")), new Language("JAR Manifest", LanguageService.listOf(new String[0]), LanguageService.listOf("MANIFEST.MF")), new Language("Gradle", LanguageService.listOf(".gradle"), LanguageService.listOf(new String[0])), new Language("Apache Conf", LanguageService.listOf(new String[0]), LanguageService.listOf(".htaccess", "apache2.conf", "httpd.conf")), new Language("NPM Config", LanguageService.listOf(new String[0]), LanguageService.listOf(".npmrc")));
    private final MavenProject project;
    private final Map<String, Language> filenameToLanguage = new HashMap<String, Language>();
    private final Map<String, Language> extensionToLanguage = new HashMap<String, Language>();

    public LanguageService(MavenProject project) {
        this.project = project;
        for (Language language : languages) {
            language.extensions.forEach(ext -> this.extensionToLanguage.put(ext.toLowerCase(Locale.US), language));
            language.filenames.forEach(filename -> this.filenameToLanguage.put(filename.toLowerCase(Locale.US), language));
        }
    }

    public List<BytesOfCode> getBytesOfCodePerLanguage() {
        HashMap bytesOfCodePerLanguage = new HashMap();
        File baseDir = this.project.getBasedir();
        MojoLogger.logger.info("Getting bytes of code in " + baseDir);
        HashSet<String> dirsToExclude = new HashSet<String>();
        String dir = this.project.getModel().getBuild().getDirectory();
        if (dir != null && !dir.isEmpty()) {
            MojoLogger.logger.info("Excuding bytes in " + dir);
            dirsToExclude.add(dir.toLowerCase(Locale.US));
        }
        if ((dir = this.project.getModel().getBuild().getOutputDirectory()) != null && !dir.isEmpty()) {
            MojoLogger.logger.info("Excuding bytes in " + dir);
            dirsToExclude.add(dir.toLowerCase(Locale.US));
        }
        if ((dir = this.project.getModel().getBuild().getTestOutputDirectory()) != null && !dir.isEmpty()) {
            MojoLogger.logger.info("Excuding bytes in " + dir);
            dirsToExclude.add(dir.toLowerCase(Locale.US));
        }
        try {
            Files.walk(baseDir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(filePath -> dirsToExclude.stream().noneMatch(d -> filePath.toFile().getAbsolutePath().toLowerCase(Locale.US).contains((CharSequence)d))).filter(filePath -> !this.isPathContainingDotFolder((Path)filePath)).forEach(filePath -> {
                String filename = filePath.toFile().getName();
                Language language = this.filenameToLanguage.get(filename = filename.toLowerCase(Locale.US));
                if (language == null && filename.contains(".")) {
                    String extensionIncludingDot = filename.substring(filename.lastIndexOf("."));
                    language = this.extensionToLanguage.get(extensionIncludingDot);
                }
                if (language != null) {
                    long nrOfBytes;
                    MojoLogger.logger.debug("Adding bytes of " + filePath.toFile().getAbsolutePath() + " as " + language.name);
                    Integer count = (Integer)bytesOfCodePerLanguage.get(language);
                    if (count == null) {
                        count = 0;
                    }
                    count = Integer.MAX_VALUE - (nrOfBytes = filePath.toFile().length()) > (long)count.intValue() ? Integer.valueOf(count + (int)nrOfBytes) : Integer.valueOf(0x7FFFFFFE);
                    bytesOfCodePerLanguage.put(language, count);
                }
            });
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Error while getting bytes of code");
            MojoLogger.logger.debug("Error", e);
        }
        return bytesOfCodePerLanguage.entrySet().stream().map(entry -> {
            BytesOfCode bytesOfCode = new BytesOfCode();
            bytesOfCode.language = ((Language)entry.getKey()).name;
            bytesOfCode.amount = (Integer)entry.getValue();
            return bytesOfCode;
        }).collect(Collectors.toList());
    }

    private boolean isPathContainingDotFolder(Path path) {
        for (Path p : path) {
            if (!Files.isDirectory(p, new LinkOption[0]) || !p.toFile().getName().startsWith(".")) continue;
            return true;
        }
        return false;
    }

    private static List<String> listOf(String ... strings) {
        if (strings == null || strings.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(strings).collect(Collectors.toList());
    }

    private static class Language {
        private final String name;
        private final List<String> extensions;
        private final List<String> filenames;

        public Language(String name, List<String> extensions, List<String> filenames) {
            this.name = name;
            this.extensions = extensions;
            this.filenames = filenames;
        }
    }
}

