/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.ReflectionService;
import io.contextmap.application.endpoints.EndpointReflection;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiEndpoint;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PublishedEndpointService {
    private static final String[] classesUsedPublishedEndpoints = new String[]{"org.springframework.web.bind.annotation.RestController", "org.springframework.stereotype.Controller"};
    private final ReflectionService reflectionService;

    public PublishedEndpointService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<RestApiEndpoint> scan() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedPublishedEndpoints);
            return classes.stream().flatMap(type -> this.toEndpoints((Class<?>)type).stream()).collect(Collectors.toList());
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for published endpoints");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private List<RestApiEndpoint> toEndpoints(Class<?> type) {
        EndpointReflection endpointReflection = new EndpointReflection(this.reflectionService);
        String pathPrefix = this.getRestControllerPath(type, endpointReflection);
        MojoLogger.logger.info("Type " + type.getSimpleName() + " has general path " + pathPrefix);
        return endpointReflection.getEndpoints(type, pathPrefix);
    }

    private String getRestControllerPath(Class<?> type, EndpointReflection endpointReflection) {
        String requestMappingType = "org.springframework.web.bind.annotation.RequestMapping";
        Annotation requestMappingAnnotation = this.reflectionService.getAnnotation(type, requestMappingType).orElse(null);
        if (requestMappingAnnotation == null) {
            Annotation[] annotations;
            for (Annotation ann : annotations = type.getAnnotations()) {
                Method[] methods;
                boolean isAnnotationWhichExtendsRequestMapping;
                boolean bl = isAnnotationWhichExtendsRequestMapping = Arrays.stream(ann.annotationType().getAnnotations()).filter(a -> a.annotationType().getName().equals(requestMappingType)).count() > 0L;
                if (!isAnnotationWhichExtendsRequestMapping) continue;
                for (Method method : methods = ann.annotationType().getDeclaredMethods()) {
                    Annotation[] methodAnnotations;
                    for (Annotation methodAnnotation : methodAnnotations = method.getAnnotations()) {
                        boolean isAliasForRequestMapping;
                        if (!methodAnnotation.annotationType().getName().equals("org.springframework.core.annotation.AliasFor")) continue;
                        Optional<Object> annotationFieldValue = this.reflectionService.getAnnotationFieldValue(methodAnnotation, "annotation");
                        boolean bl2 = isAliasForRequestMapping = annotationFieldValue.isPresent() && annotationFieldValue.get() instanceof Class && ((Class)annotationFieldValue.get()).getName().equals(requestMappingType);
                        if (!isAliasForRequestMapping) continue;
                        String attribute = this.reflectionService.getAnnotationFieldValue(methodAnnotation, "attribute").map(String::valueOf).orElse("");
                        if (!"path".equals(attribute) && !"value".equals(attribute)) {
                            attribute = this.reflectionService.getAnnotationFieldValue(methodAnnotation, "value").map(String::valueOf).orElse("");
                        }
                        if (!"path".equals(attribute) && !"value".equals(attribute)) continue;
                        try {
                            return String.valueOf(method.invoke((Object)ann, new Object[0]));
                        }
                        catch (Exception e) {
                            MojoLogger.logger.warn("Unable to get value of annotation");
                        }
                    }
                }
            }
            return "";
        }
        return endpointReflection.getPathOrValueFromAnnotation(requestMappingAnnotation);
    }
}

