/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.domain.resource.CompositeConfigurationResource;
import io.contextmap.domain.resource.ConfigurationPomFile;
import io.contextmap.domain.resource.ConfigurationPropertiesFile;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.domain.resource.ConfigurationYamlFile;
import io.contextmap.infrastructure.MojoLogger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import org.apache.maven.project.MavenProject;

public class ResourceService {
    private static final String[] propertyFiles = new String[]{"bootstrap.properties", "bootstrap.yml", "bootstrap.yaml", "application.properties", "application.yml", "application.yaml"};

    public ConfigurationResource scanConfiguration(MavenProject project) {
        CompositeConfigurationResource configurationResource = new CompositeConfigurationResource();
        for (String propertyFile : propertyFiles) {
            Path path = this.getResourcePath(project, propertyFile);
            if (!this.fileExist(path)) continue;
            this.readFile(path).ifPresent(configurationResource::addConfigurationResource);
        }
        configurationResource.addConfigurationResource(ConfigurationPomFile.create(project));
        return configurationResource;
    }

    private Path getResourcePath(MavenProject project, String filename) {
        return Paths.get(project.getBasedir().getAbsolutePath(), "src", "main", "resources", filename);
    }

    private boolean fileExist(Path file) {
        return file.toFile().exists();
    }

    private Optional<ConfigurationResource> readFile(Path filename) {
        try {
            if (this.isPropertiesFile(filename)) {
                return Optional.of(this.readPropertiesFile(filename));
            }
            return Optional.of(this.readYamlFile(filename));
        }
        catch (Exception e) {
            MojoLogger.logger.error("Error during reading of " + filename, e);
            return Optional.empty();
        }
    }

    private ConfigurationResource readPropertiesFile(Path path) throws Exception {
        MojoLogger.logger.debug("Using resource " + path.toFile().getAbsolutePath());
        return ConfigurationPropertiesFile.create(path);
    }

    private ConfigurationResource readYamlFile(Path path) throws Exception {
        MojoLogger.logger.debug("Using resource " + path.toFile().getAbsolutePath());
        return ConfigurationYamlFile.create(path);
    }

    private boolean isPropertiesFile(Path filename) {
        return filename.toString().toLowerCase().endsWith(".properties");
    }
}

