/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.contextmap.application.DecisionRecordService;
import io.contextmap.application.EntityService;
import io.contextmap.application.FeatureFileService;
import io.contextmap.application.GlossaryService;
import io.contextmap.application.LanguageService;
import io.contextmap.application.PublishedEndpointService;
import io.contextmap.application.ReflectionService;
import io.contextmap.application.ResourceService;
import io.contextmap.application.SubscribedEndpointService;
import io.contextmap.application.TechnologyStackService;
import io.contextmap.application.VersionControlService;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.infrastructure.MojoParameters;
import io.contextmap.infrastructure.client.ContextMapServerClient;
import io.contextmap.infrastructure.client.JacksonConfiguration;
import io.contextmap.infrastructure.client.ScanResponse;
import io.contextmap.model.DecisionRecordDetail;
import io.contextmap.model.DecisionRecordOverview;
import io.contextmap.model.FeatureFileDetail;
import io.contextmap.model.FeatureFileOverview;
import io.contextmap.model.ReleaseDetail;
import io.contextmap.model.ReleaseOverview;
import io.contextmap.model.Scan;
import io.contextmap.model.ScanExecution;
import io.contextmap.model.ScannedComponent;
import io.contextmap.scanner.versioncontrol.VersionControlScan;
import io.contextmap.scanner.versioncontrol.model.Tag;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;

public class ScanService {
    private final MavenProject project;
    private final PluginDescriptor plugin;
    private final ResourceService resourceService;
    private final VersionControlService versionControlService;
    private final EntityService entityService;
    private final PublishedEndpointService publishedEndpointService;
    private final SubscribedEndpointService subscribedEndpointService;
    private final DecisionRecordService decisionRecordService;
    private final FeatureFileService featureFileService;
    private final GlossaryService glossaryService;
    private final LanguageService languageService;
    private final TechnologyStackService technologyStackService;
    private final ContextMapServerClient client;
    private List<Tag> tagCache;

    public ScanService(MavenProject project, PluginDescriptor plugin, MojoParameters parameters) {
        this.project = project;
        this.plugin = plugin;
        this.client = new ContextMapServerClient(parameters);
        this.resourceService = new ResourceService();
        this.versionControlService = new VersionControlService();
        this.decisionRecordService = new DecisionRecordService();
        this.featureFileService = new FeatureFileService();
        this.languageService = new LanguageService(project);
        this.technologyStackService = new TechnologyStackService(project);
        ReflectionService reflectionService = new ReflectionService(project);
        this.entityService = new EntityService(reflectionService);
        this.glossaryService = new GlossaryService(reflectionService);
        this.publishedEndpointService = new PublishedEndpointService(reflectionService);
        this.subscribedEndpointService = new SubscribedEndpointService(reflectionService);
    }

    public void scan() {
        Scan scan = this.initializeScan();
        this.scanConfiguration(scan);
        this.scanVersionControl(scan);
        this.scanEntities(scan);
        this.scanGlossaryTerms(scan);
        this.scanDecisionRecords(scan);
        this.scanFeatureFiles(scan);
        this.scanPublishedEndpoints(scan);
        this.scanSubscribedEndpoints(scan);
        this.scanBytesOfCode(scan);
        this.scanTechStack(scan);
        this.saveLocalCopyAsJson(scan);
        Optional<ScanResponse> optResponse = this.sendScan(scan);
        optResponse.ifPresent(response -> {
            this.sendDecisionRecordDetails(response.componentId, scan.decisionRecordOverviews, response.decisionRecordsToSend);
            this.sendFeatureFileDetails(response.componentId, scan.featureFileOverviews, response.featureFilesToSend);
            this.sendReleases(response.componentId, response.releasesToSend);
        });
    }

    private Scan initializeScan() {
        Scan scan = new Scan();
        scan.execution = new ScanExecution();
        scan.scannedComponent = new ScannedComponent();
        scan.scannedComponent.version = this.project.getVersion();
        scan.pluginVersion = this.plugin.getVersion();
        scan.pluginName = this.plugin.getGroupId() + ":" + this.plugin.getArtifactId();
        return scan;
    }

    private void scanVersionControl(Scan scan) {
        VersionControlScan versionControlScan = this.versionControlService.scan();
        scan.execution.scannedCommitLog = true;
        scan.commitDetails = versionControlScan.commitDetailList;
        scan.scannedComponent.recentCommits = versionControlScan.commitOverviewList;
        scan.execution.scannedReleases = true;
        this.tagCache = versionControlScan.tagList;
        scan.releaseOverviews = this.tagCache.stream().map(tag -> {
            ReleaseOverview ro = new ReleaseOverview();
            ro.name = tag.name;
            return ro;
        }).collect(Collectors.toList());
    }

    private void scanConfiguration(Scan scan) {
        ConfigurationResource configResource = this.resourceService.scanConfiguration(this.project);
        scan.execution.scannedProperties = true;
        scan.execution.scannedSystem = true;
        scan.scannedComponent.name = configResource.getName();
        scan.scannedComponent.type = configResource.getComponentType();
        scan.scannedComponent.domainVisionStatement = configResource.getDomainVisionStatement();
        scan.scannedComponent.team = configResource.getTeam();
        scan.scannedComponent.systemName = configResource.getSystemName();
        scan.scannedComponent.urlBuildPipeline = configResource.getUrlBuildPipeline();
        scan.scannedComponent.urlDocumentation = configResource.getUrlDocumentation();
        scan.scannedComponent.urlIssueManagement = configResource.getUrlIssueManagement();
        scan.scannedComponent.urlVersionControl = configResource.getUrlVersionControl();
    }

    private void scanEntities(Scan scan) {
        MojoLogger.logger.info("Scanning for entities");
        scan.execution.scannedEntities = true;
        scan.entities = this.entityService.scan();
        MojoLogger.logger.info("Found " + scan.entities.size() + " entities");
    }

    private void scanGlossaryTerms(Scan scan) {
        MojoLogger.logger.info("Scanning for glossary terms");
        scan.execution.scannedGlossary = true;
        scan.glossaryTerms = this.glossaryService.scan();
        MojoLogger.logger.info("Found " + scan.glossaryTerms.size() + " glossary terms");
    }

    private void scanPublishedEndpoints(Scan scan) {
        MojoLogger.logger.info("Scanning for published endpoints");
        scan.execution.scannedRestApi = true;
        scan.publishedEndpoints = this.publishedEndpointService.scan();
        MojoLogger.logger.info("Found " + scan.publishedEndpoints.size() + " published endpoints");
    }

    private void scanBytesOfCode(Scan scan) {
        MojoLogger.logger.info("Scanning bytes of code");
        scan.execution.scannedBytesOfCode = true;
        scan.scannedComponent.bytesOfCodes = this.languageService.getBytesOfCodePerLanguage();
        MojoLogger.logger.info("Found " + scan.scannedComponent.bytesOfCodes.size() + " languages");
    }

    private void scanTechStack(Scan scan) {
        MojoLogger.logger.info("Scanning techstack");
        scan.execution.scannedTechnologies = true;
        scan.scannedComponent.technologies = this.technologyStackService.scan();
        MojoLogger.logger.info("Found " + scan.scannedComponent.technologies.size() + " technologies");
    }

    private void scanSubscribedEndpoints(Scan scan) {
        MojoLogger.logger.info("Scanning for subscribed endpoints");
        scan.execution.scannedSubscribedEndpoints = true;
        scan.subscribedEndpoints = this.subscribedEndpointService.scan();
        MojoLogger.logger.info("Found " + scan.subscribedEndpoints.size() + " subscribed endpoints");
    }

    private void scanDecisionRecords(Scan scan) {
        Path baseDir = this.project.getBasedir().toPath();
        MojoLogger.logger.info("Scanning for architecture decision records in " + baseDir);
        scan.execution.scannedDecisionRecords = true;
        scan.decisionRecordOverviews = this.decisionRecordService.scan(baseDir);
        MojoLogger.logger.info("Found " + scan.decisionRecordOverviews.size() + " decision records");
    }

    private void scanFeatureFiles(Scan scan) {
        Path baseDir = this.project.getBasedir().toPath();
        MojoLogger.logger.info("Scanning for feature files in " + baseDir);
        scan.execution.scannedFeatureFiles = true;
        scan.featureFileOverviews = this.featureFileService.scan(baseDir);
        MojoLogger.logger.info("Found " + scan.featureFileOverviews.size() + " feature files");
    }

    private Optional<ScanResponse> sendScan(Scan scan) {
        try {
            MojoLogger.logger.info("Sending scan for processing");
            return Optional.ofNullable(this.client.processScan(scan));
        }
        catch (Exception e) {
            MojoLogger.logger.error("Sending failed", e);
            return Optional.empty();
        }
    }

    private void saveLocalCopyAsJson(Scan scan) {
        try {
            Path outputDirectory = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            String outputFileName = "contextmap_" + this.project.getName() + "-" + this.project.getVersion() + ".json";
            Path outputFile = outputDirectory.resolveSibling(outputFileName);
            ObjectMapper objectMapper = JacksonConfiguration.createObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            byte[] data = objectMapper.writeValueAsBytes((Object)scan);
            Files.write(outputFile, data, new OpenOption[0]);
            MojoLogger.logger.info("Saved local copy as " + outputFile.toFile().getAbsolutePath());
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to save local copy of json, will be skipped");
        }
    }

    private void sendReleases(String componentId, List<ReleaseOverview> requestedReleases) {
        Set requestedTagNames = requestedReleases.stream().map(ro -> ro.name).collect(Collectors.toSet());
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.tagCache.stream().filter(tag -> requestedTagNames.contains(tag.name)).forEach(tag -> {
            try {
                ReleaseDetail releaseDetail = new ReleaseDetail();
                releaseDetail.componentId = componentId;
                releaseDetail.name = tag.name;
                releaseDetail.createdOn = tag.createdOn == null ? null : dateTimeFormatter.format(tag.createdOn);
                releaseDetail.commitDetails = tag.commits;
                MojoLogger.logger.info("Sending details of release " + tag.name + " requested by server");
                this.client.addRelease(releaseDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send release", e);
            }
        });
    }

    private void sendFeatureFileDetails(String componentId, List<FeatureFileOverview> scannedOverviews, List<FeatureFileOverview> requestedOverviews) {
        if (requestedOverviews == null) {
            MojoLogger.logger.info("Server requested no feature file details");
            return;
        }
        requestedOverviews.stream().map(requestedFF -> scannedOverviews.stream().filter(ff -> ff.contentHash.equals(requestedFF.contentHash)).findFirst().orElseThrow(() -> new RuntimeException("Requested FeatureFile not found!?"))).map(scannedFF -> this.featureFileService.createFeatureFileDetail(componentId, (FeatureFileOverview)scannedFF)).filter(Optional::isPresent).forEach(ffDetailOptional -> {
            try {
                FeatureFileDetail ffDetail = (FeatureFileDetail)ffDetailOptional.get();
                MojoLogger.logger.info("Sending details of feature file " + ffDetail.name + " requested by server");
                this.client.addFeatureFile(ffDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send feature file", e);
            }
        });
    }

    private void sendDecisionRecordDetails(String componentId, List<DecisionRecordOverview> scannedOverviews, List<DecisionRecordOverview> requestedOverviews) {
        if (requestedOverviews == null) {
            MojoLogger.logger.info("Server requested no decision records details");
            return;
        }
        requestedOverviews.stream().map(requestedADR -> scannedOverviews.stream().filter(adr -> adr.contentHash.equals(requestedADR.contentHash)).findFirst().orElseThrow(() -> new RuntimeException("Requested ADR not found!?"))).map(scannedADR -> this.decisionRecordService.createDecisionRecordDetail(componentId, (DecisionRecordOverview)scannedADR)).filter(Optional::isPresent).forEach(adrDetailOptional -> {
            try {
                DecisionRecordDetail adrDetail = (DecisionRecordDetail)adrDetailOptional.get();
                MojoLogger.logger.info("Sending details of decision record " + adrDetail.name + " requested by server");
                this.client.addDecisionRecord(adrDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send decision record", e);
            }
        });
    }
}

