/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.ReflectionService;
import io.contextmap.application.endpoints.EndpointReflection;
import io.contextmap.application.endpoints.SpEL;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiEndpoint;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class SubscribedEndpointService {
    private static final String[] classesUsedSubscribedEndpoints = new String[]{"org.springframework.cloud.openfeign.FeignClient"};
    private final ReflectionService reflectionService;

    public SubscribedEndpointService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<RestApiEndpoint> scan() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(classesUsedSubscribedEndpoints);
            return classes.stream().flatMap(type -> this.toEndpoints((Class<?>)type).stream()).collect(Collectors.toList());
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for subscribed endpoints");
            MojoLogger.logger.debug("Exception", e);
            return Collections.emptyList();
        }
    }

    private List<RestApiEndpoint> toEndpoints(Class<?> type) {
        String pathPrefix = this.getClientPath(type);
        MojoLogger.logger.info("Type " + type.getSimpleName() + " has general path " + pathPrefix);
        EndpointReflection endpointReflection = new EndpointReflection(this.reflectionService);
        List<RestApiEndpoint> endpoints = endpointReflection.getEndpoints(type, pathPrefix);
        String componentName = this.getComponentName(type);
        endpoints.forEach(e -> {
            e.componentName = componentName;
        });
        return endpoints;
    }

    private String getClientPath(Class<?> type) {
        String feignClientType = "org.springframework.cloud.openfeign.FeignClient";
        Annotation annotation = this.reflectionService.getAnnotation(type, feignClientType).orElse(null);
        if (annotation == null) {
            return "";
        }
        return this.getPathFromAnnotation(annotation);
    }

    private String getComponentName(Class<?> type) {
        String feignClientType = "org.springframework.cloud.openfeign.FeignClient";
        Annotation annotation = this.reflectionService.getAnnotation(type, feignClientType).orElse(null);
        if (annotation == null) {
            return "";
        }
        String name = this.getValueNameOrServiceIdFromAnnotation(annotation);
        return SpEL.extractDefaultValue(name);
    }

    private String getPathFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "path");
        return result.map(value -> (String)value).orElse("");
    }

    private String getValueNameOrServiceIdFromAnnotation(Annotation annotation) {
        Optional<Object> result = this.reflectionService.getAnnotationFieldValue(annotation, "value");
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "name");
        }
        if (!result.isPresent() || result.get().equals("")) {
            result = this.reflectionService.getAnnotationFieldValue(annotation, "serviceId");
        }
        return result.map(value -> (String)value).orElse("");
    }
}

