/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.Technology;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class TechnologyStackService {
    private Map<WellKnownLibrary, WellKnownLibrary> technologies = Stream.of(TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-web", "Spring Boot Web"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-security", "Spring Boot Security"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-amqp", "Spring Boot AMQP"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-actuator", "Spring Boot Actuator"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-cache", "Spring Boot Cache"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-integration", "Spring Boot Integration"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-data-mongodb", "Spring Boot Data MongoDB"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-data-jpa", "Spring Boot Data JPA"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-data-jdbc", "Spring Boot Data JDBC"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-netflix-eureka-client", "Spring Cloud Eureka Client"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-openfeign", "Spring Cloud OpenFeign"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-sleuth", "Spring Cloud Sleuth"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-zipkin", "Spring Cloud Zipkin")).collect(Collectors.toMap(Function.identity(), Function.identity()));
    private final MavenProject project;

    public TechnologyStackService(MavenProject project) {
        this.project = project;
    }

    public List<Technology> scan() {
        return this.project.getDependencies().stream().map(this::mapToTechnology).collect(Collectors.toList());
    }

    private Technology mapToTechnology(Dependency dependency) {
        WellKnownLibrary lib = new WellKnownLibrary();
        lib.groupId = dependency.getGroupId();
        lib.artifactId = dependency.getArtifactId();
        Technology technology = new Technology();
        technology.technicalName = dependency.getGroupId() + "::" + dependency.getArtifactId();
        technology.version = dependency.getVersion();
        technology.wellKnown = false;
        technology.displayName = "";
        WellKnownLibrary matchingLibrary = this.technologies.get(lib);
        if (matchingLibrary != null) {
            technology.wellKnown = true;
            technology.displayName = matchingLibrary.displayName;
        }
        MojoLogger.logger.debug("Found technology " + (technology.wellKnown ? technology.displayName : technology.technicalName));
        return technology;
    }

    private static WellKnownLibrary libFor(String groupId, String artifactId, String displayName) {
        WellKnownLibrary library = new WellKnownLibrary();
        library.groupId = groupId;
        library.artifactId = artifactId;
        library.displayName = displayName;
        return library;
    }

    private static class WellKnownLibrary {
        private String groupId;
        private String artifactId;
        private String displayName;

        private WellKnownLibrary() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WellKnownLibrary that = (WellKnownLibrary)o;
            return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId);
        }
    }
}

