/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.domain.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.ComponentType;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public class ConfigurationYamlFile
extends ConfigurationResource {
    private JsonNode node;

    public static ConfigurationYamlFile create(Path path) throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode node = mapper.readTree(path.toFile());
        ConfigurationYamlFile resource = new ConfigurationYamlFile();
        resource.node = node;
        return resource;
    }

    @Override
    public ComponentType getComponentType() {
        if (this.node == null) {
            return null;
        }
        JsonNode nameNode = this.node.path("contextmap").path("scan").path("component-type");
        String componentTypeProperty = this.getNodeAsText(nameNode).orElse(null);
        if (componentTypeProperty != null && !componentTypeProperty.isEmpty()) {
            try {
                return ComponentType.valueOf((String)componentTypeProperty);
            }
            catch (Exception e) {
                String supportedValues = Arrays.stream(ComponentType.values()).map(Enum::name).collect(Collectors.joining(", "));
                MojoLogger.logger.error("Unable to map provided component-type \"" + componentTypeProperty + "\" to any of the supported values: " + supportedValues);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.node == null) {
            return null;
        }
        JsonNode nameNode = this.node.path("spring").path("application").path("name");
        return this.getNodeAsText(nameNode).orElse(null);
    }

    @Override
    public String getSystemName() {
        if (this.node == null) {
            return null;
        }
        JsonNode nameNode = this.node.path("contextmap").path("scan").path("system-name");
        return this.getNodeAsText(nameNode).orElse(null);
    }

    @Override
    public String getDomainVisionStatement() {
        return null;
    }

    @Override
    public String getTeam() {
        return null;
    }

    @Override
    public String getUrlDocumentation() {
        return null;
    }

    @Override
    public String getUrlVersionControl() {
        return null;
    }

    @Override
    public String getUrlIssueManagement() {
        return null;
    }

    @Override
    public String getUrlBuildPipeline() {
        return null;
    }

    private Optional<String> getNodeAsText(JsonNode node) {
        if (node.isMissingNode() || !node.isTextual()) {
            return Optional.empty();
        }
        String text = node.asText();
        if (text == null || text.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(text);
    }
}

