/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.infrastructure.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.contextmap.infrastructure.MojoParameters;
import io.contextmap.infrastructure.client.JacksonConfiguration;
import io.contextmap.infrastructure.client.ScanResponse;
import io.contextmap.infrastructure.client.SigninRequest;
import io.contextmap.infrastructure.client.SigninResponse;
import io.contextmap.model.DecisionRecordDetail;
import io.contextmap.model.FeatureFileDetail;
import io.contextmap.model.ReleaseDetail;
import io.contextmap.model.Scan;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class ContextMapServerClient {
    private static final String MEDIATYPE_JSON = "application/json";
    private static final String MEDIATYPE_JSON_UTF8 = "application/json;charset=UTF-8";
    private final MojoParameters parameters;
    private final String host;
    private final ObjectMapper objectMapper;
    private final SigninResponse signinResponse;

    public ContextMapServerClient(MojoParameters parameters) {
        this.parameters = parameters;
        this.host = "https://contextmap-server.azurewebsites.net";
        this.objectMapper = JacksonConfiguration.createObjectMapper();
        try {
            this.signinResponse = this.signIn();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to sign in");
        }
    }

    public ScanResponse processScan(Scan scan) throws Exception {
        return this.sendScan(scan, this.signinResponse);
    }

    public void addRelease(ReleaseDetail releaseDetail) throws Exception {
        String url = this.host + "/scans/releases";
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)releaseDetail);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            httpPost.setHeader("Authorization", "Bearer " + this.signinResponse.getJwt());
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                HttpEntity responseEntity = response.getEntity();
                String responseString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "No reason given";
                throw new RuntimeException("Send failed, status: " + statusCode + ", reason: " + responseString);
            }
        }
    }

    public void addDecisionRecord(DecisionRecordDetail adrDetail) throws Exception {
        String url = this.host + "/scans/decision-records";
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)adrDetail);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            httpPost.setHeader("Authorization", "Bearer " + this.signinResponse.getJwt());
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                HttpEntity responseEntity = response.getEntity();
                String responseString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "No reason given";
                throw new RuntimeException("Send failed, status: " + statusCode + ", reason: " + responseString);
            }
        }
    }

    public void addFeatureFile(FeatureFileDetail ffDetail) throws Exception {
        String url = this.host + "/scans/feature-files";
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)ffDetail);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            httpPost.setHeader("Authorization", "Bearer " + this.signinResponse.getJwt());
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                HttpEntity responseEntity = response.getEntity();
                String responseString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "No reason given";
                throw new RuntimeException("Send failed, status: " + statusCode + ", reason: " + responseString);
            }
        }
    }

    private SigninResponse signIn() throws Exception {
        String url = this.host + "/api/auth/signin";
        SigninRequest request = new SigninRequest(this.parameters.getUsername(), this.parameters.getPassword());
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)request);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                throw new RuntimeException("Signin failed, status: " + statusCode);
            }
            SigninResponse signinResponse = this.convertResponseToEntity(response, SigninResponse.class);
            return signinResponse;
        }
    }

    private ScanResponse sendScan(Scan scan, SigninResponse signinResponse) throws Exception {
        String url = this.host + "/scans";
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpPost httpPost = new HttpPost(url);
            String requestAsString = this.objectMapper.writeValueAsString((Object)scan);
            StringEntity entity = new StringEntity(requestAsString, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Accept", MEDIATYPE_JSON);
            httpPost.setHeader("Content-type", MEDIATYPE_JSON_UTF8);
            httpPost.setHeader("Authorization", "Bearer " + signinResponse.getJwt());
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode > 299) {
                HttpEntity responseEntity = response.getEntity();
                String responseString = responseEntity != null ? EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8) : "No reason given";
                throw new RuntimeException("Send failed, status: " + statusCode + ", reason: " + responseString);
            }
            ScanResponse scanResponse = this.convertResponseToEntity(response, ScanResponse.class);
            return scanResponse;
        }
    }

    private <T> T convertResponseToEntity(CloseableHttpResponse response, Class<T> type) throws Exception {
        HttpEntity responseEntity = response.getEntity();
        String responseString = EntityUtils.toString((HttpEntity)responseEntity, (Charset)StandardCharsets.UTF_8);
        return (T)this.objectMapper.readValue(responseString, type);
    }
}

