/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reflections.Configuration;
import org.reflections.ReflectionUtils;
import org.reflections.ReflectionsException;
import org.reflections.Store;
import org.reflections.scanners.FieldAnnotationsScanner;
import org.reflections.scanners.MemberUsageScanner;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterNamesScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.Utils;
import org.reflections.vfs.Vfs;
import org.slf4j.Logger;

public class Reflections_0_9_12_withFixForIssue273 {
    public static Logger log = Utils.findLogger(Reflections_0_9_12_withFixForIssue273.class);
    protected final transient Configuration configuration;
    protected Store store;

    public Reflections_0_9_12_withFixForIssue273(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store();
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            try {
                Set scanners = configuration.getScanners() == null ? Collections.emptySet() : configuration.getScanners();
                Field storeMapField = this.store.getClass().getDeclaredField("storeMap");
                storeMapField.setAccessible(true);
                ConcurrentHashMap reflectedStoreMap = (ConcurrentHashMap)storeMapField.get(this.store);
                scanners.forEach(s -> reflectedStoreMap.put(Utils.index(s.getClass()), new ConcurrentHashMap()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
            }
            this.scan();
            if (configuration.shouldExpandSuperTypes()) {
                this.expandSuperTypes();
            }
        }
    }

    public Reflections_0_9_12_withFixForIssue273(String prefix, Scanner ... scanners) {
        this(new Object[]{prefix, scanners});
    }

    public Reflections_0_9_12_withFixForIssue273(Object ... params) {
        this((Configuration)ConfigurationBuilder.build((Object[])params));
    }

    protected Reflections_0_9_12_withFixForIssue273() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store();
    }

    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            if (log != null) {
                log.warn("given scan urls are empty. set urls in the configuration");
            }
            return;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("going to scan these urls: {}", (Object)this.configuration.getUrls());
        }
        long time = System.currentTimeMillis();
        int scannedUrls = 0;
        ExecutorService executorService = this.configuration.getExecutorService();
        ArrayList futures = new ArrayList();
        for (URL uRL : this.configuration.getUrls()) {
            try {
                if (executorService != null) {
                    futures.add(executorService.submit(() -> {
                        if (log != null) {
                            log.debug("[{}] scanning {}", (Object)Thread.currentThread().toString(), (Object)url);
                        }
                        this.scan(url);
                    }));
                } else {
                    this.scan(uRL);
                }
                ++scannedUrls;
            }
            catch (ReflectionsException e) {
                if (log == null) continue;
                log.warn("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
            }
        }
        if (executorService != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (executorService != null) {
            executorService.shutdown();
        }
        if (log != null) {
            log.info(String.format("Reflections took %d ms to scan %d urls, producing %s %s", System.currentTimeMillis() - time, scannedUrls, Reflections_0_9_12_withFixForIssue273.producingDescription(this.store), executorService instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService).getMaximumPoolSize()) : ""));
        }
    }

    private static String producingDescription(Store store) {
        int keys = 0;
        int values = 0;
        for (String index : store.keySet()) {
            keys += store.keys(index).size();
            values += store.values(index).size();
        }
        return String.format("%d keys and %d values", keys, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(URL url) {
        try (Vfs.Dir dir = Vfs.fromURL((URL)url);){
            for (Vfs.File file : dir.getFiles()) {
                Predicate inputsFilter = this.configuration.getInputsFilter();
                String path = file.getRelativePath();
                String fqn = path.replace('/', '.');
                if (inputsFilter != null && !inputsFilter.test(path) && !inputsFilter.test(fqn)) continue;
                Object classObject = null;
                for (Scanner scanner : this.configuration.getScanners()) {
                    try {
                        if (!scanner.acceptsInput(path) && !scanner.acceptsInput(fqn)) continue;
                        classObject = scanner.scan(file, classObject, this.store);
                    }
                    catch (Exception e) {
                        if (log == null) continue;
                        log.debug("could not scan file {} in url {} with scanner {}", new Object[]{file.getRelativePath(), url.toExternalForm(), scanner.getClass().getSimpleName(), e});
                    }
                }
            }
        }
    }

    public Reflections_0_9_12_withFixForIssue273 merge(Reflections_0_9_12_withFixForIssue273 reflections) {
        this.store.merge(reflections.store);
        return this;
    }

    public void expandSuperTypes() {
        String index = Utils.index(SubTypesScanner.class);
        Set keys = this.store.keys(index);
        keys.removeAll(this.store.values(index));
        for (String key : keys) {
            Class type = ReflectionUtils.forName((String)key, (ClassLoader[])this.loaders());
            if (type == null) continue;
            this.expandSupertypes(this.store, key, type);
        }
    }

    private void expandSupertypes(Store store, String key, Class<?> type) {
        for (Class supertype : ReflectionUtils.getSuperTypes(type)) {
            if (!store.put(SubTypesScanner.class, supertype.getName(), key)) continue;
            if (log != null) {
                log.debug("expanded subtype {} -> {}", (Object)supertype.getName(), (Object)key);
            }
            this.expandSupertypes(store, supertype.getName(), supertype);
        }
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        return ReflectionUtils.forNames((Collection)this.store.getAll(SubTypesScanner.class, type.getName()), (ClassLoader[])this.loaders());
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Set annotated = this.store.get(TypeAnnotationsScanner.class, annotation.getName());
        annotated.addAll(this.getAllAnnotated(annotated, annotation, honorInherited));
        return ReflectionUtils.forNames((Collection)annotated, (ClassLoader[])this.loaders());
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        Set annotated = this.store.get(TypeAnnotationsScanner.class, annotation.annotationType().getName());
        Set allAnnotated = Utils.filter((Collection)ReflectionUtils.forNames((Collection)annotated, (ClassLoader[])this.loaders()), (Predicate)ReflectionUtils.withAnnotation((Annotation)annotation));
        Set classes = ReflectionUtils.forNames((Collection)Utils.filter(this.getAllAnnotated(Utils.names((Collection)allAnnotated), annotation.annotationType(), honorInherited), s -> !annotated.contains(s)), (ClassLoader[])this.loaders());
        allAnnotated.addAll(classes);
        return allAnnotated;
    }

    protected Collection<String> getAllAnnotated(Collection<String> annotated, Class<? extends Annotation> annotation, boolean honorInherited) {
        if (honorInherited) {
            if (annotation.isAnnotationPresent(Inherited.class)) {
                Set subTypes = this.store.get(SubTypesScanner.class, (Collection)Utils.filter(annotated, input -> {
                    Class type = ReflectionUtils.forName((String)input, (ClassLoader[])this.loaders());
                    return type != null && !type.isInterface();
                }));
                return this.store.getAllIncluding(SubTypesScanner.class, (Collection)subTypes);
            }
            return annotated;
        }
        Set subTypes = this.store.getAllIncluding(TypeAnnotationsScanner.class, annotated);
        return this.store.getAllIncluding(SubTypesScanner.class, (Collection)subTypes);
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        return Utils.getMethodsFromDescriptors((Iterable)this.store.get(MethodAnnotationsScanner.class, annotation.getName()), (ClassLoader[])this.loaders());
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        return Utils.filter(this.getMethodsAnnotatedWith(annotation.annotationType()), (Predicate)ReflectionUtils.withAnnotation((Annotation)annotation));
    }

    public Set<Method> getMethodsMatchParams(Class<?> ... types) {
        return Utils.getMethodsFromDescriptors((Iterable)this.store.get(MethodParameterScanner.class, Utils.names((Class[])types).toString()), (ClassLoader[])this.loaders());
    }

    public Set<Method> getMethodsReturn(Class returnType) {
        return Utils.getMethodsFromDescriptors((Iterable)this.store.get(MethodParameterScanner.class, (Collection)Utils.names((Class[])new Class[]{returnType})), (ClassLoader[])this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        return Utils.getMethodsFromDescriptors((Iterable)this.store.get(MethodParameterScanner.class, annotation.getName()), (ClassLoader[])this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Annotation annotation) {
        return Utils.filter(this.getMethodsWithAnyParamAnnotated(annotation.annotationType()), (Predicate)ReflectionUtils.withAnyParameterAnnotation((Annotation)annotation));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Class<? extends Annotation> annotation) {
        return Utils.getConstructorsFromDescriptors((Iterable)this.store.get(MethodAnnotationsScanner.class, annotation.getName()), (ClassLoader[])this.loaders());
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Annotation annotation) {
        return Utils.filter(this.getConstructorsAnnotatedWith(annotation.annotationType()), (Predicate)ReflectionUtils.withAnnotation((Annotation)annotation));
    }

    public Set<Constructor> getConstructorsMatchParams(Class<?> ... types) {
        return Utils.getConstructorsFromDescriptors((Iterable)this.store.get(MethodParameterScanner.class, Utils.names((Class[])types).toString()), (ClassLoader[])this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        return Utils.getConstructorsFromDescriptors((Iterable)this.store.get(MethodParameterScanner.class, annotation.getName()), (ClassLoader[])this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Annotation annotation) {
        return Utils.filter(this.getConstructorsWithAnyParamAnnotated(annotation.annotationType()), (Predicate)ReflectionUtils.withAnyParameterAnnotation((Annotation)annotation));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.store.get(FieldAnnotationsScanner.class, annotation.getName()).stream().map(annotated -> Utils.getFieldFromString((String)annotated, (ClassLoader[])this.loaders())).collect(Collectors.toSet());
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        return Utils.filter(this.getFieldsAnnotatedWith(annotation.annotationType()), (Predicate)ReflectionUtils.withAnnotation((Annotation)annotation));
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        Set resources = Utils.filter((Collection)this.store.keys(Utils.index(ResourcesScanner.class)), namePredicate);
        return this.store.get(ResourcesScanner.class, (Collection)resources);
    }

    public Set<String> getResources(Pattern pattern) {
        return this.getResources((String input) -> pattern.matcher((CharSequence)input).matches());
    }

    public List<String> getMethodParamNames(Method method) {
        Set names = this.store.get(MethodParameterNamesScanner.class, Utils.name((Method)method));
        return names.size() == 1 ? Arrays.asList(((String)names.iterator().next()).split(", ")) : Collections.emptyList();
    }

    public List<String> getConstructorParamNames(Constructor constructor) {
        Set names = this.store.get(MethodParameterNamesScanner.class, Utils.name((Constructor)constructor));
        return names.size() == 1 ? Arrays.asList(((String)names.iterator().next()).split(", ")) : Collections.emptyList();
    }

    public Set<Member> getFieldUsage(Field field) {
        return Utils.getMembersFromDescriptors((Iterable)this.store.get(MemberUsageScanner.class, Utils.name((Field)field)), (ClassLoader[])new ClassLoader[0]);
    }

    public Set<Member> getMethodUsage(Method method) {
        return Utils.getMembersFromDescriptors((Iterable)this.store.get(MemberUsageScanner.class, Utils.name((Method)method)), (ClassLoader[])new ClassLoader[0]);
    }

    public Set<Member> getConstructorUsage(Constructor constructor) {
        return Utils.getMembersFromDescriptors((Iterable)this.store.get(MemberUsageScanner.class, Utils.name((Constructor)constructor)), (ClassLoader[])new ClassLoader[0]);
    }

    public Set<String> getAllTypes() {
        HashSet<String> allTypes = new HashSet<String>(this.store.getAll(SubTypesScanner.class, Object.class.getName()));
        if (allTypes.isEmpty()) {
            throw new ReflectionsException("Couldn't find subtypes of Object. Make sure SubTypesScanner initialized to include Object class - new SubTypesScanner(false)");
        }
        return allTypes;
    }

    public Store getStore() {
        return this.store;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private ClassLoader[] loaders() {
        return this.configuration.getClassLoaders();
    }
}

