/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.google.common.collect.Streams;
import io.contextmap.annotations.actor.ContextActor;
import io.contextmap.annotations.actor.ContextActors;
import io.contextmap.application.ReflectionService;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.Actor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ActorService {
    private final ReflectionService reflectionService;
    private static final String classUsedByActor = ContextActor.class.getName();
    private static final String groupclassUsedByActor = ContextActors.class.getName();

    public ActorService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public List<Actor> scan() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(new String[]{classUsedByActor, groupclassUsedByActor});
            return this.scanClasses(classes);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for entities");
            return Collections.emptyList();
        }
    }

    private List<Actor> scanClasses(Collection<Class<?>> classes) {
        Stream<Annotation> actorAnnotations = classes.stream().map(clazz -> this.reflectionService.getAnnotation((Class<?>)clazz, classUsedByActor)).filter(Optional::isPresent).map(Optional::get);
        Stream actorGroupAnnotations = classes.stream().map(clazz -> this.reflectionService.getAnnotation((Class<?>)clazz, groupclassUsedByActor)).filter(Optional::isPresent).map(Optional::get).map(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).filter(Optional::isPresent).map(Optional::get).flatMap(value -> Arrays.stream((ContextActor[])value));
        Stream annotationsFromSinglesAndGroups = Streams.concat((Stream[])new Stream[]{actorAnnotations, actorGroupAnnotations});
        Stream<String> actorNames = annotationsFromSinglesAndGroups.map(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).filter(Optional::isPresent).map(Optional::get).map(String.class::cast).filter(name -> name.length() > 0).distinct();
        return actorNames.map(this::createActor).collect(Collectors.toList());
    }

    private Actor createActor(String name) {
        Actor actor = new Actor();
        actor.name = name;
        return actor;
    }
}

