/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.FileContentReader;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.DiagramDetail;
import io.contextmap.model.DiagramOverview;
import io.contextmap.scanner.decisionrecords.DiagramsScanner;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class DiagramService {
    private static final int MAX_DIAGRAM_NR_OF_CHARACTERS = 250000;
    private final DiagramsScanner diagramsScanner = new DiagramsScanner((VersionControlLogger)new Logger());

    public List<DiagramOverview> scan(Path baseDir) {
        return this.diagramsScanner.scan(baseDir);
    }

    public Optional<DiagramDetail> createDiagramDetail(String componentId, String parentComponentId, DiagramOverview requestedDiagram) {
        DiagramDetail diagramDetail = new DiagramDetail();
        diagramDetail.name = requestedDiagram.name;
        diagramDetail.contentHash = requestedDiagram.contentHash;
        diagramDetail.componentId = componentId;
        diagramDetail.parentComponentId = parentComponentId;
        try {
            diagramDetail.content = FileContentReader.readContent(requestedDiagram.filePath, 250000);
        }
        catch (Exception e) {
            MojoLogger.logger.error("Error while reading filecontent " + requestedDiagram.filePath, e);
            return Optional.empty();
        }
        return Optional.of(diagramDetail);
    }

    public static class Logger
    implements VersionControlLogger {
        public void warn(String message) {
            MojoLogger.logger.warn(message);
        }

        public void info(String message) {
            MojoLogger.logger.info(message);
        }

        public void debug(String message) {
            MojoLogger.logger.debug(message);
        }
    }
}

