/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.infrastructure.MojoLogger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

public class FileContentReader {
    public static String readContent(Path filePath, int maxNrOfChars) throws Exception {
        StringBuilder contentBuilder = new StringBuilder();
        try (Stream<String> stream = Files.lines(filePath, StandardCharsets.UTF_8);){
            stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
        }
        String content = contentBuilder.toString();
        if (content.length() > maxNrOfChars) {
            MojoLogger.logger.warn("The following file is larger than the maximum (" + maxNrOfChars + " bytes) and will be truncated: " + filePath);
            content = content.substring(0, maxNrOfChars);
        }
        return content;
    }
}

