/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.contextmap.application.ActorService;
import io.contextmap.application.DecisionRecordService;
import io.contextmap.application.DiagramService;
import io.contextmap.application.EntityService;
import io.contextmap.application.ExemplarService;
import io.contextmap.application.FeatureFileService;
import io.contextmap.application.GlossaryService;
import io.contextmap.application.LanguageService;
import io.contextmap.application.PublishedEndpointService;
import io.contextmap.application.ReflectionService;
import io.contextmap.application.ResourceService;
import io.contextmap.application.RestApiInfoService;
import io.contextmap.application.SubscribedEndpointService;
import io.contextmap.application.TechRadarService;
import io.contextmap.application.TechnologyStackService;
import io.contextmap.application.VersionControlService;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.infrastructure.MojoParameters;
import io.contextmap.infrastructure.client.ContextMapServerClient;
import io.contextmap.infrastructure.client.JacksonConfiguration;
import io.contextmap.infrastructure.client.ScanResponse;
import io.contextmap.model.ComponentType;
import io.contextmap.model.DecisionRecordDetail;
import io.contextmap.model.DecisionRecordForOverview;
import io.contextmap.model.DecisionRecordOverview;
import io.contextmap.model.DiagramDetail;
import io.contextmap.model.DiagramOverview;
import io.contextmap.model.FeatureFileDetail;
import io.contextmap.model.FeatureFileOverview;
import io.contextmap.model.ReleaseDetail;
import io.contextmap.model.ReleaseOverview;
import io.contextmap.model.Scan;
import io.contextmap.model.ScanExecution;
import io.contextmap.model.ScannedComponent;
import io.contextmap.scanner.versioncontrol.VersionControlScan;
import io.contextmap.scanner.versioncontrol.model.Tag;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;

public class ScanService {
    private static final SimpleDateFormat releaseDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final MavenProject project;
    private final PluginDescriptor plugin;
    private final ResourceService resourceService;
    private final VersionControlService versionControlService;
    private final EntityService entityService;
    private final ActorService actorService;
    private final PublishedEndpointService publishedEndpointService;
    private final SubscribedEndpointService subscribedEndpointService;
    private final RestApiInfoService restApiInfoService;
    private final TechRadarService techRadarService;
    private final DecisionRecordService decisionRecordService;
    private final DiagramService diagramService;
    private final FeatureFileService featureFileService;
    private final GlossaryService glossaryService;
    private final ExemplarService exemplarService;
    private final LanguageService languageService;
    private final TechnologyStackService technologyStackService;
    private final ContextMapServerClient client;
    private final MojoParameters parameters;
    private final ReflectionService reflectionService;
    private ConfigurationResource configResource;
    private List<Tag> tagCache;
    private String decisionRecordFilenameForOverview;

    public ScanService(MavenProject project, PluginDescriptor plugin, MojoParameters parameters) {
        this.project = project;
        this.plugin = plugin;
        this.parameters = parameters;
        this.client = new ContextMapServerClient(parameters);
        this.resourceService = new ResourceService();
        this.versionControlService = new VersionControlService();
        this.decisionRecordService = new DecisionRecordService();
        this.diagramService = new DiagramService();
        this.featureFileService = new FeatureFileService();
        this.languageService = new LanguageService(project);
        this.technologyStackService = new TechnologyStackService(project);
        this.techRadarService = new TechRadarService(parameters);
        this.reflectionService = new ReflectionService(project);
        this.entityService = new EntityService(this.reflectionService);
        this.actorService = new ActorService(this.reflectionService);
        this.glossaryService = new GlossaryService(this.reflectionService);
        this.exemplarService = new ExemplarService(this.reflectionService, this.versionControlService);
        this.publishedEndpointService = new PublishedEndpointService(this.reflectionService);
        this.subscribedEndpointService = new SubscribedEndpointService(this.reflectionService);
        this.restApiInfoService = new RestApiInfoService(this.reflectionService);
    }

    public void scan() {
        Scan scan = this.initializeScan();
        this.scanConfiguration(scan);
        this.scanVersionControl(scan);
        this.scanEntities(scan);
        this.scanGlossaryTerms(scan);
        this.scanExemplars(scan);
        this.scanDecisionRecords(scan);
        this.scanDiagrams(scan);
        this.scanFeatureFiles(scan);
        this.scanRestApiInfo(scan);
        this.scanPublishedEndpoints(scan);
        this.scanSubscribedEndpoints(scan);
        this.scanBytesOfCode(scan);
        this.scanTechStack(scan);
        this.scanActors(scan);
        this.scanTechRadar(scan);
        this.saveLocalCopyAsJson(scan);
        Optional<ScanResponse> optResponse = this.sendScan(scan);
        optResponse.ifPresent(response -> {
            this.sendDecisionRecordDetails(response.componentId, response.parentComponentId, scan.decisionRecordOverviews, response.decisionRecordsToSend);
            this.sendDiagramDetails(response.componentId, response.parentComponentId, scan.diagramOverviews, response.diagramsToSend);
            this.sendFeatureFileDetails(response.componentId, response.parentComponentId, scan.featureFileOverviews, response.featureFilesToSend);
            this.sendReleases(response.componentId, response.parentComponentId, response.releasesToSend);
        });
    }

    private Scan initializeScan() {
        Scan scan = new Scan();
        scan.execution = new ScanExecution();
        scan.scannedComponent = new ScannedComponent();
        scan.scannedComponent.version = this.project.getVersion();
        scan.pluginVersion = this.plugin.getVersion();
        scan.pluginName = this.plugin.getGroupId() + ":" + this.plugin.getArtifactId();
        return scan;
    }

    private void scanVersionControl(Scan scan) {
        VersionControlScan versionControlScan = this.versionControlService.scan();
        scan.execution.scannedCommitLog = true;
        scan.commitDetails = versionControlScan.commitDetailList;
        scan.scannedComponent.recentCommits = versionControlScan.commitOverviewList;
        scan.execution.scannedReleases = true;
        this.tagCache = versionControlScan.tagList;
        scan.releaseOverviews = this.tagCache.stream().map(tag -> {
            ReleaseOverview ro = new ReleaseOverview();
            ro.name = tag.name;
            ro.createdOn = tag.createdOn == null ? null : releaseDateTimeFormatter.format(tag.createdOn);
            return ro;
        }).collect(Collectors.toList());
    }

    private void scanConfiguration(Scan scan) {
        block6: {
            block5: {
                this.configResource = this.resourceService.scanConfiguration(this.project);
                scan.execution.scannedProperties = true;
                scan.execution.scannedSystem = true;
                scan.scannedComponent.name = this.configResource.getName();
                scan.scannedComponent.type = this.scanComponentType(this.configResource);
                scan.scannedComponent.domainVisionStatement = this.configResource.getDomainVisionStatement();
                scan.scannedComponent.team = this.configResource.getTeam();
                scan.scannedComponent.organization = this.configResource.getOrganization();
                scan.scannedComponent.teamMail = this.configResource.getTeamMail();
                scan.scannedComponent.systemName = this.configResource.getSystemName();
                scan.scannedComponent.urlBuildPipeline = this.configResource.getUrlBuildPipeline();
                scan.scannedComponent.urlDocumentation = this.configResource.getUrlDocumentation();
                scan.scannedComponent.urlIssueManagement = this.configResource.getUrlIssueManagement();
                scan.scannedComponent.urlVersionControl = this.configResource.getUrlVersionControl();
                this.decisionRecordFilenameForOverview = this.configResource.getDecisionRecordFilenameForOverview();
                if (scan.scannedComponent.urlVersionControl == null) break block5;
                if (!scan.scannedComponent.urlVersionControl.isEmpty()) break block6;
            }
            scan.scannedComponent.urlVersionControl = this.versionControlService.getRemoteOriginUrl().map(this.versionControlService::gitUrlToHttp).orElse(null);
        }
        if (this.parameters.isMultiModuleProject()) {
            scan.scannedComponent.moduleName = scan.scannedComponent.name;
            scan.scannedComponent.name = this.parameters.getMultiModuleComponentName();
            scan.scannedComponent.rootModule = this.parameters.isRootModule();
            if (this.parameters.isRootModule()) {
                MojoLogger.logger.info("Found root module");
            }
        }
    }

    private ComponentType scanComponentType(ConfigurationResource configResource) {
        ComponentType hardcodedType = configResource.getComponentType();
        if (hardcodedType != null) {
            return hardcodedType;
        }
        String springCloudGateway = "org.springframework.cloud.gateway.config.GatewayAutoConfiguration";
        if (this.reflectionService.isClassAvailable(springCloudGateway)) {
            return ComponentType.GATEWAY;
        }
        return ComponentType.MICROSERVICE;
    }

    private void scanEntities(Scan scan) {
        MojoLogger.logger.info("Scanning for entities");
        scan.execution.scannedEntities = true;
        scan.entities = this.entityService.scan();
        MojoLogger.logger.info("Found " + scan.entities.size() + " entities");
    }

    private void scanTechRadar(Scan scan) {
        MojoLogger.logger.info("Scanning for tech-radar");
        scan.execution.scannedTechRadarEntries = true;
        scan.techRadarEntries = this.techRadarService.scan();
        MojoLogger.logger.info("Found " + scan.techRadarEntries.size() + " tech-radar entries");
    }

    private void scanActors(Scan scan) {
        MojoLogger.logger.info("Scanning for actors");
        scan.execution.scannedActors = true;
        scan.actors = this.actorService.scan();
        MojoLogger.logger.info("Found " + scan.actors.size() + " actors");
    }

    private void scanGlossaryTerms(Scan scan) {
        MojoLogger.logger.info("Scanning for glossary terms");
        scan.execution.scannedGlossary = true;
        scan.glossaryTerms = this.glossaryService.scan();
        MojoLogger.logger.info("Found " + scan.glossaryTerms.size() + " glossary terms");
    }

    private void scanExemplars(Scan scan) {
        MojoLogger.logger.info("Scanning for exemplars");
        scan.execution.scannedExemplars = true;
        scan.exemplars = this.exemplarService.scan(this.project);
        MojoLogger.logger.info("Found " + scan.exemplars.size() + " exemplars");
    }

    private void scanRestApiInfo(Scan scan) {
        MojoLogger.logger.info("Scanning for rest api info");
        this.restApiInfoService.scan().ifPresent(restApiInfo -> {
            scan.restApiInfo = restApiInfo;
        });
        if (scan.restApiInfo == null) {
            MojoLogger.logger.info("Could not find rest api info");
        } else {
            MojoLogger.logger.info("Found rest api info");
        }
    }

    private void scanPublishedEndpoints(Scan scan) {
        Path baseDir = this.project.getBasedir().toPath();
        MojoLogger.logger.info("Scanning for published endpoints");
        scan.execution.scannedRestApi = true;
        scan.publishedEndpointGroups = this.publishedEndpointService.scan(baseDir);
        MojoLogger.logger.info("Found " + scan.publishedEndpointGroups.size() + " published endpoint groups");
    }

    private void scanBytesOfCode(Scan scan) {
        MojoLogger.logger.info("Scanning bytes of code");
        scan.execution.scannedBytesOfCode = true;
        scan.scannedComponent.bytesOfCodes = this.languageService.getBytesOfCodePerLanguage();
        MojoLogger.logger.info("Found " + scan.scannedComponent.bytesOfCodes.size() + " languages");
    }

    private void scanTechStack(Scan scan) {
        MojoLogger.logger.info("Scanning techstack");
        scan.execution.scannedTechnologies = true;
        scan.scannedComponent.technologies = this.technologyStackService.scan();
        MojoLogger.logger.info("Found " + scan.scannedComponent.technologies.size() + " technologies");
    }

    private void scanSubscribedEndpoints(Scan scan) {
        MojoLogger.logger.info("Scanning for subscribed endpoints");
        scan.execution.scannedSubscribedEndpoints = true;
        scan.subscribedEndpoints = this.subscribedEndpointService.scan();
        List routeEndpoints = this.configResource.getGatewayRoutes().stream().map(this.subscribedEndpointService::createAnonymousEndpoint).collect(Collectors.toList());
        if (!routeEndpoints.isEmpty()) {
            MojoLogger.logger.info("Including gateway routes as subscribed endpoints");
            if (scan.subscribedEndpoints == null) {
                scan.subscribedEndpoints = new ArrayList();
            }
            scan.subscribedEndpoints.addAll(routeEndpoints);
        }
        MojoLogger.logger.info("Found " + scan.subscribedEndpoints.size() + " subscribed endpoints");
    }

    private void scanDecisionRecords(Scan scan) {
        Path baseDir = this.project.getBasedir().toPath();
        MojoLogger.logger.info("Scanning for architecture decision records in " + baseDir);
        scan.execution.scannedDecisionRecords = true;
        scan.decisionRecordOverviews = this.decisionRecordService.scan(baseDir);
        MojoLogger.logger.info("Found " + scan.decisionRecordOverviews.size() + " decision records");
    }

    private void scanDiagrams(Scan scan) {
        Path baseDir = this.project.getBasedir().toPath();
        MojoLogger.logger.info("Scanning for diagrams in " + baseDir);
        scan.execution.scannedDiagrams = true;
        scan.diagramOverviews = this.diagramService.scan(baseDir);
        MojoLogger.logger.info("Found " + scan.diagramOverviews.size() + " diagrams");
    }

    private void scanFeatureFiles(Scan scan) {
        Path baseDir = this.project.getBasedir().toPath();
        MojoLogger.logger.info("Scanning for feature files in " + baseDir);
        scan.execution.scannedFeatureFiles = true;
        scan.featureFileOverviews = this.featureFileService.scan(baseDir);
        MojoLogger.logger.info("Found " + scan.featureFileOverviews.size() + " feature files");
    }

    private Optional<ScanResponse> sendScan(Scan scan) {
        try {
            MojoLogger.logger.info("Sending scan for processing");
            return Optional.ofNullable(this.client.processScan(scan));
        }
        catch (Exception e) {
            MojoLogger.logger.error("Sending failed", e);
            return Optional.empty();
        }
    }

    private void saveLocalCopyAsJson(Scan scan) {
        try {
            Path outputDirectory = Paths.get(this.project.getBuild().getOutputDirectory(), new String[0]);
            String outputFileName = "contextmap_" + this.project.getName() + "-" + this.project.getVersion() + ".json";
            Path outputFile = outputDirectory.resolveSibling(outputFileName);
            ObjectMapper objectMapper = JacksonConfiguration.createObjectMapper();
            objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
            byte[] data = objectMapper.writeValueAsBytes((Object)scan);
            Files.write(outputFile, data, new OpenOption[0]);
            MojoLogger.logger.info("Saved local copy as " + outputFile.toFile().getAbsolutePath());
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to save local copy of json, will be skipped");
        }
    }

    private void sendReleases(String componentId, String parentComponentId, List<ReleaseOverview> requestedReleases) {
        Set requestedTagNames = requestedReleases.stream().map(ro -> ro.name).collect(Collectors.toSet());
        this.tagCache.stream().filter(tag -> requestedTagNames.contains(tag.name)).forEach(tag -> {
            try {
                ReleaseDetail releaseDetail = new ReleaseDetail();
                releaseDetail.componentId = componentId;
                releaseDetail.parentComponentId = parentComponentId;
                releaseDetail.name = tag.name;
                releaseDetail.createdOn = tag.createdOn == null ? null : releaseDateTimeFormatter.format(tag.createdOn);
                releaseDetail.commitDetails = tag.commits;
                MojoLogger.logger.info("Sending details of release " + tag.name + " requested by server");
                this.client.addRelease(releaseDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send release", e);
            }
        });
    }

    private void sendFeatureFileDetails(String componentId, String parentComponentId, List<FeatureFileOverview> scannedOverviews, List<FeatureFileOverview> requestedOverviews) {
        if (requestedOverviews == null) {
            MojoLogger.logger.info("Server requested no feature file details");
            return;
        }
        requestedOverviews.stream().map(requestedFF -> scannedOverviews.stream().filter(ff -> ff.contentHash.equals(requestedFF.contentHash)).findFirst().orElseThrow(() -> new RuntimeException("Requested FeatureFile not found!?"))).map(scannedFF -> this.featureFileService.createFeatureFileDetail(componentId, parentComponentId, (FeatureFileOverview)scannedFF)).filter(Optional::isPresent).forEach(ffDetailOptional -> {
            try {
                FeatureFileDetail ffDetail = (FeatureFileDetail)ffDetailOptional.get();
                MojoLogger.logger.info("Sending details of feature file " + ffDetail.name + " requested by server");
                this.client.addFeatureFile(ffDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send feature file", e);
            }
        });
    }

    private void sendDiagramDetails(String componentId, String parentComponentId, List<DiagramOverview> scannedOverviews, List<DiagramOverview> requestedOverviews) {
        if (requestedOverviews == null) {
            MojoLogger.logger.info("Server requested no diagram details");
            return;
        }
        requestedOverviews.stream().map(requestedDiagram -> scannedOverviews.stream().filter(adr -> adr.contentHash.equals(requestedDiagram.contentHash)).findFirst().orElseThrow(() -> new RuntimeException("Requested diagram not found!?"))).map(scannedDiagram -> this.diagramService.createDiagramDetail(componentId, parentComponentId, (DiagramOverview)scannedDiagram)).filter(Optional::isPresent).forEach(diagramDetailOptional -> {
            try {
                DiagramDetail diagramDetail = (DiagramDetail)diagramDetailOptional.get();
                MojoLogger.logger.info("Sending details of diagram " + diagramDetail.name + " requested by server");
                this.client.addDiagram(diagramDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send diagram", e);
            }
        });
    }

    private void setDecisionRecordForOverview(String componentId, String parentComponentId, List<DecisionRecordOverview> scannedOverviews) {
        try {
            if (this.decisionRecordFilenameForOverview == null || this.decisionRecordFilenameForOverview.isEmpty()) {
                MojoLogger.logger.info("Clearing decision record for overview");
                DecisionRecordForOverview adrDetail = new DecisionRecordForOverview();
                adrDetail.contentHash = null;
                adrDetail.componentId = componentId;
                adrDetail.parentComponentId = parentComponentId;
                this.client.setDecisionRecordForOverview(adrDetail);
            } else {
                String contentHash = scannedOverviews.stream().filter(scannedOverview -> scannedOverview.name.equalsIgnoreCase(this.decisionRecordFilenameForOverview)).findFirst().map(scannedOverview -> scannedOverview.contentHash).orElse(null);
                MojoLogger.logger.info("Setting decision record for overview (hash: " + contentHash + ")");
                DecisionRecordForOverview adrDetail = new DecisionRecordForOverview();
                adrDetail.contentHash = contentHash;
                adrDetail.componentId = componentId;
                adrDetail.parentComponentId = parentComponentId;
                this.client.setDecisionRecordForOverview(adrDetail);
            }
        }
        catch (Exception e) {
            MojoLogger.logger.error("Unable to set decision record for overview", e);
        }
    }

    private void sendDecisionRecordDetails(String componentId, String parentComponentId, List<DecisionRecordOverview> scannedOverviews, List<DecisionRecordOverview> requestedOverviews) {
        if (requestedOverviews == null) {
            MojoLogger.logger.info("Server requested no decision records details");
            this.setDecisionRecordForOverview(componentId, parentComponentId, scannedOverviews);
            return;
        }
        requestedOverviews.stream().map(requestedADR -> scannedOverviews.stream().filter(adr -> adr.contentHash.equals(requestedADR.contentHash)).findFirst().orElseThrow(() -> new RuntimeException("Requested ADR not found!?"))).map(scannedADR -> this.decisionRecordService.createDecisionRecordDetail(componentId, parentComponentId, (DecisionRecordOverview)scannedADR)).filter(Optional::isPresent).forEach(adrDetailOptional -> {
            try {
                DecisionRecordDetail adrDetail = (DecisionRecordDetail)adrDetailOptional.get();
                MojoLogger.logger.info("Sending details of decision record " + adrDetail.name + " requested by server");
                this.client.addDecisionRecord(adrDetail);
            }
            catch (Exception e) {
                MojoLogger.logger.error("Unable to send decision record", e);
            }
        });
        this.setDecisionRecordForOverview(componentId, parentComponentId, scannedOverviews);
    }
}

