/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.Technology;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;

public class TechnologyStackService {
    private Map<WellKnownLibrary, WellKnownLibrary> technologies = Stream.of(TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-web", "Spring Boot Web"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-security", "Spring Boot Security"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-amqp", "Spring Boot AMQP"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-actuator", "Spring Boot Actuator"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-cache", "Spring Boot Cache"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-integration", "Spring Boot Integration"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-data-mongodb", "Spring Boot Data MongoDB"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-data-jpa", "Spring Boot Data JPA"), TechnologyStackService.libFor("org.springframework.boot", "spring-boot-starter-data-jdbc", "Spring Boot Data JDBC"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-netflix-eureka-client", "Spring Cloud Eureka Client"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-openfeign", "Spring Cloud OpenFeign"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-sleuth", "Spring Cloud Sleuth"), TechnologyStackService.libFor("org.springframework.cloud", "spring-cloud-starter-zipkin", "Spring Cloud Zipkin")).collect(Collectors.toMap(Function.identity(), Function.identity()));
    private final MavenProject project;

    public TechnologyStackService(MavenProject project) {
        this.project = project;
    }

    public List<Technology> scan() {
        ArrayList<Technology> technologies = new ArrayList<Technology>();
        technologies.addAll(this.scanMavenDependencies());
        technologies.addAll(this.scanGitHubWorkflows());
        return technologies;
    }

    private Collection<Technology> scanMavenDependencies() {
        HashMap technologyMap = new HashMap();
        this.project.getDependencies().stream().map(this::mapToTechnology).forEach(tech -> technologyMap.put(tech.technicalName, tech));
        try {
            this.project.getArtifacts().stream().filter(artf -> !technologyMap.containsKey(this.createTechnicalName(artf.getGroupId(), artf.getArtifactId()))).filter(artf -> artf.getScope() != null && artf.getScope().contains("compile")).map(this::mapToTechnology).forEach(tech -> technologyMap.put(tech.technicalName, tech));
        }
        catch (Throwable t) {
            MojoLogger.logger.error("Problem while scanning for transitive technologies: " + t.getMessage());
        }
        return technologyMap.values();
    }

    private Collection<Technology> scanGitHubWorkflows() {
        HashMap technologiesMap = new HashMap();
        try {
            Path baseDir = this.project.getBasedir().toPath();
            Path githubFolderPath = baseDir.resolve(".github");
            if (!githubFolderPath.toFile().exists()) {
                return Collections.emptyList();
            }
            Files.find(githubFolderPath, Integer.MAX_VALUE, (filePath, fileAttr) -> fileAttr.isRegularFile() && (filePath.toFile().getName().toUpperCase(Locale.US).endsWith(".YML") || filePath.toFile().getName().toUpperCase(Locale.US).endsWith(".YAML")), new FileVisitOption[0]).forEach(yamlFile -> {
                List<Technology> techs = this.mapGitHubYamlToTechnology((Path)yamlFile);
                for (Technology tech : techs) {
                    technologiesMap.putIfAbsent(tech.technicalName.toUpperCase(Locale.US) + tech.version, tech);
                }
            });
        }
        catch (Throwable t) {
            MojoLogger.logger.error("Problem while scanning for GitHub workflows: " + t.getMessage());
        }
        return technologiesMap.values();
    }

    List<Technology> mapGitHubYamlToTechnology(Path path) {
        try {
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            JsonNode node = mapper.readTree(path.toFile());
            Set<String> libraries = this.processGitHubJsonNode("", node);
            return libraries.stream().map(lib -> {
                Technology technology = new Technology();
                if (lib.contains("@") && !lib.endsWith("@")) {
                    int index = lib.lastIndexOf("@");
                    technology.technicalName = lib.substring(0, index);
                    technology.version = lib.substring(index + 1);
                } else {
                    technology.technicalName = lib;
                    technology.version = "";
                }
                technology.wellKnown = false;
                technology.displayName = "";
                return technology;
            }).collect(Collectors.toList());
        }
        catch (Throwable t) {
            MojoLogger.logger.error("Problem while scanning for GitHub workflows: " + t.getMessage());
            return null;
        }
    }

    private Set<String> processGitHubJsonNode(String prefix, JsonNode currentNode) {
        HashSet<String> libraries = new HashSet<String>();
        String delimiter = "->";
        if (currentNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)currentNode;
            Iterator node = arrayNode.elements();
            int index = 1;
            while (node.hasNext()) {
                Set<String> libs = this.processGitHubJsonNode(!prefix.isEmpty() ? prefix + delimiter + index : String.valueOf(index), (JsonNode)node.next());
                libraries.addAll(libs);
                ++index;
            }
        } else if (currentNode.isObject()) {
            currentNode.fields().forEachRemaining(entry -> {
                Set<String> libs = this.processGitHubJsonNode(!prefix.isEmpty() ? prefix + delimiter + (String)entry.getKey() : (String)entry.getKey(), (JsonNode)entry.getValue());
                libraries.addAll(libs);
            });
        } else {
            String matcher = delimiter + "uses";
            if (prefix.toUpperCase(Locale.US).endsWith(matcher.toUpperCase(Locale.US))) {
                libraries.add(currentNode.toString().replace("\"", ""));
            }
        }
        return libraries;
    }

    private String createTechnicalName(String groupId, String artifactId) {
        return groupId + "::" + artifactId;
    }

    private Technology mapToTechnology(Artifact artifact) {
        WellKnownLibrary lib = new WellKnownLibrary();
        lib.groupId = artifact.getGroupId();
        lib.artifactId = artifact.getArtifactId();
        Technology technology = new Technology();
        technology.technicalName = this.createTechnicalName(artifact.getGroupId(), artifact.getArtifactId());
        technology.version = artifact.getVersion();
        technology.wellKnown = false;
        technology.displayName = "";
        technology.transitive = true;
        WellKnownLibrary matchingLibrary = this.technologies.get(lib);
        if (matchingLibrary != null) {
            technology.wellKnown = true;
            technology.displayName = matchingLibrary.displayName;
        }
        MojoLogger.logger.debug("Found transitive technology " + (technology.wellKnown ? technology.displayName : technology.technicalName));
        return technology;
    }

    private Technology mapToTechnology(Dependency dependency) {
        WellKnownLibrary lib = new WellKnownLibrary();
        lib.groupId = dependency.getGroupId();
        lib.artifactId = dependency.getArtifactId();
        Technology technology = new Technology();
        technology.technicalName = this.createTechnicalName(dependency.getGroupId(), dependency.getArtifactId());
        technology.version = dependency.getVersion();
        technology.wellKnown = false;
        technology.displayName = "";
        technology.transitive = false;
        WellKnownLibrary matchingLibrary = this.technologies.get(lib);
        if (matchingLibrary != null) {
            technology.wellKnown = true;
            technology.displayName = matchingLibrary.displayName;
        }
        MojoLogger.logger.debug("Found technology " + (technology.wellKnown ? technology.displayName : technology.technicalName));
        return technology;
    }

    private static WellKnownLibrary libFor(String groupId, String artifactId, String displayName) {
        WellKnownLibrary library = new WellKnownLibrary();
        library.groupId = groupId;
        library.artifactId = artifactId;
        library.displayName = displayName;
        return library;
    }

    private static class WellKnownLibrary {
        private String groupId;
        private String artifactId;
        private String displayName;

        private WellKnownLibrary() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WellKnownLibrary that = (WellKnownLibrary)o;
            return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId);
        }
    }
}

