/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.domain.resource;

import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.ComponentType;
import java.io.FileReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;

public class ConfigurationPropertiesFile
extends ConfigurationResource {
    private Properties properties;

    public static ConfigurationPropertiesFile create(Path path) throws Exception {
        Properties props = new Properties();
        props.load(new FileReader(path.toFile()));
        ConfigurationPropertiesFile resource = new ConfigurationPropertiesFile();
        resource.properties = props;
        return resource;
    }

    @Override
    public ComponentType getComponentType() {
        String componentTypeProperty = this.properties.getProperty("contextmap.scan.component-type");
        if (componentTypeProperty != null && !componentTypeProperty.isEmpty()) {
            try {
                return ComponentType.valueOf((String)componentTypeProperty);
            }
            catch (Exception e) {
                String supportedValues = Arrays.stream(ComponentType.values()).map(Enum::name).collect(Collectors.joining(", "));
                MojoLogger.logger.error("Unable to map provided component-type \"" + componentTypeProperty + "\" to any of the supported values: " + supportedValues);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return this.properties.getProperty("spring.application.name");
    }

    @Override
    public String getSystemName() {
        return this.properties.getProperty("contextmap.scan.system-name");
    }

    @Override
    public String getDecisionRecordFilenameForOverview() {
        return this.properties.getProperty("contextmap.scan.overview-decision-record");
    }

    @Override
    public String getDomainVisionStatement() {
        return null;
    }

    @Override
    public String getTeam() {
        return null;
    }

    @Override
    public String getTeamMail() {
        return null;
    }

    @Override
    public String getOrganization() {
        return null;
    }

    @Override
    public String getUrlDocumentation() {
        return null;
    }

    @Override
    public String getUrlVersionControl() {
        return null;
    }

    @Override
    public String getUrlIssueManagement() {
        return null;
    }

    @Override
    public String getUrlBuildPipeline() {
        return null;
    }

    @Override
    public List<String> getGatewayRoutes() {
        return this.properties.entrySet().stream().filter(entry -> String.valueOf(entry.getKey()).startsWith("spring.cloud.gateway.routes[") && String.valueOf(entry.getKey()).contains("].uri")).map(entry -> String.valueOf(entry.getValue())).filter(text -> text.toLowerCase().startsWith("lb://")).map(text -> text.substring(5)).map(text -> {
            if (text.endsWith("/")) {
                return text.substring(0, text.length() - 1);
            }
            return text;
        }).collect(Collectors.toList());
    }
}

