/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.domain.resource;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.ComponentType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ConfigurationYamlFile
extends ConfigurationResource {
    private JsonNode node;

    public static ConfigurationYamlFile create(Path path) throws Exception {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        JsonNode node = mapper.readTree(path.toFile());
        ConfigurationYamlFile resource = new ConfigurationYamlFile();
        resource.node = node;
        return resource;
    }

    @Override
    public ComponentType getComponentType() {
        if (this.node == null) {
            return null;
        }
        JsonNode nameNode = this.node.path("contextmap").path("scan").path("component-type");
        String componentTypeProperty = this.getNodeAsText(nameNode).orElse(null);
        if (componentTypeProperty != null && !componentTypeProperty.isEmpty()) {
            try {
                return ComponentType.valueOf((String)componentTypeProperty);
            }
            catch (Exception e) {
                String supportedValues = Arrays.stream(ComponentType.values()).map(Enum::name).collect(Collectors.joining(", "));
                MojoLogger.logger.error("Unable to map provided component-type \"" + componentTypeProperty + "\" to any of the supported values: " + supportedValues);
            }
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.node == null) {
            return null;
        }
        JsonNode customComponentNameNode = this.node.path("contextmap").path("scan").path("component-name");
        String customComponentName = this.getNodeAsText(customComponentNameNode).orElse(null);
        if (customComponentName != null && !customComponentName.isEmpty()) {
            return customComponentName;
        }
        JsonNode nameNode = this.node.path("spring").path("application").path("name");
        return this.getNodeAsText(nameNode).orElse(null);
    }

    @Override
    public String getSystemName() {
        if (this.node == null) {
            return null;
        }
        JsonNode nameNode = this.node.path("contextmap").path("scan").path("system-name");
        return this.getNodeAsText(nameNode).orElse(null);
    }

    @Override
    public String getDecisionRecordFilenameForOverview() {
        if (this.node == null) {
            return null;
        }
        JsonNode nameNode = this.node.path("contextmap").path("scan").path("overview-decision-record");
        return this.getNodeAsText(nameNode).orElse(null);
    }

    @Override
    public String getDomainVisionStatement() {
        return null;
    }

    @Override
    public String getTeam() {
        return null;
    }

    @Override
    public String getTeamMail() {
        return null;
    }

    @Override
    public String getOrganization() {
        return null;
    }

    @Override
    public String getUrlDocumentation() {
        return null;
    }

    @Override
    public String getUrlVersionControl() {
        return null;
    }

    @Override
    public String getUrlIssueManagement() {
        return null;
    }

    @Override
    public String getUrlBuildPipeline() {
        return null;
    }

    @Override
    public List<String> getGatewayRoutes() {
        if (this.node == null) {
            return Collections.emptyList();
        }
        JsonNode routesNode = this.node.path("spring").path("cloud").path("gateway").path("routes");
        if (routesNode.isMissingNode() || !routesNode.isArray()) {
            return Collections.emptyList();
        }
        ArrayList<String> routes = new ArrayList<String>();
        Iterator it = ((ArrayNode)routesNode).elements();
        while (it.hasNext()) {
            JsonNode route = (JsonNode)it.next();
            JsonNode uri = route.path("uri");
            this.getNodeAsText(uri).filter(text -> text.toLowerCase().startsWith("lb://")).map(text -> text.substring(5)).map(text -> {
                if (text.endsWith("/")) {
                    return text.substring(0, text.length() - 1);
                }
                return text;
            }).ifPresent(routes::add);
        }
        return routes;
    }

    private Optional<String> getNodeAsText(JsonNode node) {
        if (node.isMissingNode() || !node.isTextual()) {
            return Optional.empty();
        }
        String text = node.asText();
        if (text == null || text.trim().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(text);
    }
}

