/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.DecisionRecordService;
import io.contextmap.application.FileContentReader;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.FeatureFileDetail;
import io.contextmap.model.FeatureFileOverview;
import io.contextmap.scanner.decisionrecords.FeatureFilesScanner;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class FeatureFileService {
    private static final int MAX_FEATUREFILE_NR_OF_CHARACTERS = 80000;
    private final FeatureFilesScanner featureFilesScanner = new FeatureFilesScanner((VersionControlLogger)new DecisionRecordService.Logger());

    public List<FeatureFileOverview> scan(Path baseDir) {
        return this.featureFilesScanner.scan(baseDir);
    }

    public Optional<FeatureFileDetail> createFeatureFileDetail(String componentId, String parentComponentId, FeatureFileOverview requestedFF) {
        FeatureFileDetail ffDetail = new FeatureFileDetail();
        ffDetail.name = requestedFF.name;
        ffDetail.contentHash = requestedFF.contentHash;
        ffDetail.componentId = componentId;
        ffDetail.parentComponentId = parentComponentId;
        try {
            ffDetail.content = FileContentReader.readContent(requestedFF.filePath, 80000);
        }
        catch (Exception e) {
            MojoLogger.logger.error("Error while reading filecontent " + requestedFF.filePath, e);
            return Optional.empty();
        }
        return Optional.of(ffDetail);
    }
}

