/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.domain.resource;

import io.contextmap.domain.resource.ConfigurationResource;
import io.contextmap.model.ComponentType;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.apache.maven.model.Developer;
import org.apache.maven.project.MavenProject;

public class ConfigurationPomFile
extends ConfigurationResource {
    private MavenProject project;
    private String pomFileContent;

    public static ConfigurationPomFile create(MavenProject project) {
        ConfigurationPomFile resource = new ConfigurationPomFile();
        resource.project = project;
        resource.pomFileContent = ConfigurationPomFile.readPomFileContent(project);
        return resource;
    }

    private static String readPomFileContent(MavenProject project) {
        block8: {
            try {
                File pomFile = project.getFile();
                if (pomFile == null) break block8;
                StringBuilder contentBuilder = new StringBuilder();
                try (Stream<String> stream = Files.lines(pomFile.toPath(), StandardCharsets.UTF_8);){
                    stream.forEach(s -> contentBuilder.append((String)s).append("\n"));
                }
                return contentBuilder.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public ComponentType getComponentType() {
        return null;
    }

    @Override
    public String getName() {
        return this.project.getName();
    }

    @Override
    public String getAliases() {
        return null;
    }

    @Override
    public String getSystemName() {
        return this.project.getGroupId();
    }

    @Override
    public String getDecisionRecordFilenameForOverview() {
        return null;
    }

    @Override
    public String getDomainVisionStatement() {
        if (!this.pomFileContent.contains("<description>")) {
            return null;
        }
        return this.project.getDescription();
    }

    @Override
    public String getTeam() {
        if (!this.pomFileContent.contains("<developers>") || !this.pomFileContent.contains("<developer>")) {
            return null;
        }
        if (this.project.getDevelopers() != null && !this.project.getDevelopers().isEmpty()) {
            return ((Developer)this.project.getDevelopers().get(0)).getName();
        }
        return null;
    }

    @Override
    public String getTeamMail() {
        if (!this.pomFileContent.contains("<developers>") || !this.pomFileContent.contains("<developer>")) {
            return null;
        }
        if (this.project.getDevelopers() != null && !this.project.getDevelopers().isEmpty()) {
            return ((Developer)this.project.getDevelopers().get(0)).getEmail();
        }
        return null;
    }

    @Override
    public String getOrganization() {
        if (!this.pomFileContent.contains("<developers>") || !this.pomFileContent.contains("<developer>")) {
            return null;
        }
        if (this.project.getDevelopers() != null && !this.project.getDevelopers().isEmpty()) {
            return ((Developer)this.project.getDevelopers().get(0)).getOrganization();
        }
        return null;
    }

    @Override
    public String getUrlDocumentation() {
        if (!this.pomFileContent.contains("<url>")) {
            return null;
        }
        if (this.project.getUrl() != null && this.project.getUrl().startsWith("https://spring.io/projects/spring-boot/")) {
            return null;
        }
        return this.project.getUrl();
    }

    @Override
    public String getUrlVersionControl() {
        String url;
        if (!this.pomFileContent.contains("<scm>")) {
            return null;
        }
        if (this.project.getScm() != null && (url = this.project.getScm().getUrl()) != null && !url.contains("/spring-boot/")) {
            return url;
        }
        return null;
    }

    @Override
    public String getUrlIssueManagement() {
        if (!this.pomFileContent.contains("<issueManagement>")) {
            return null;
        }
        if (this.project.getIssueManagement() != null) {
            return this.project.getIssueManagement().getUrl();
        }
        return null;
    }

    @Override
    public String getUrlBuildPipeline() {
        if (!this.pomFileContent.contains("<ciManagement>")) {
            return null;
        }
        if (this.project.getCiManagement() != null) {
            return this.project.getCiManagement().getUrl();
        }
        return null;
    }

    @Override
    public List<String> getGatewayRoutes() {
        return Collections.emptyList();
    }
}

