/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.infrastructure;

import io.contextmap.domain.TechRadar;
import java.util.Base64;

public class MojoParameters {
    private String clearTextText;
    private String multiModuleComponentName;
    private boolean rootModule;
    private TechRadar techRadar;

    public void setKey(String key) {
        String keyString;
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Missing required key configuration parameter");
        }
        try {
            byte[] data = Base64.getDecoder().decode(key);
            keyString = new String(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid key configuration parameter");
        }
        int colonIndex = keyString.indexOf(58);
        if (colonIndex < 0) {
            throw new IllegalArgumentException("Invalid key configuration parameter");
        }
        this.clearTextText = keyString;
    }

    public String getUsername() {
        int colonIndex = this.clearTextText.indexOf(58);
        return this.clearTextText.substring(0, colonIndex);
    }

    public String getPassword() {
        int colonIndex = this.clearTextText.indexOf(58);
        return this.clearTextText.substring(colonIndex + 1);
    }

    public String getMultiModuleComponentName() {
        return this.multiModuleComponentName;
    }

    public boolean isMultiModuleProject() {
        return this.multiModuleComponentName != null && this.multiModuleComponentName.length() > 0;
    }

    public void setMultiModuleComponentName(String multiModuleComponentName) {
        this.multiModuleComponentName = multiModuleComponentName;
    }

    public boolean isRootModule() {
        return this.rootModule;
    }

    public void setRootModule(boolean rootModule) {
        this.rootModule = rootModule;
    }

    public TechRadar getTechRadar() {
        return this.techRadar;
    }

    public void setTechRadar(TechRadar techRadar) {
        this.techRadar = techRadar;
    }
}

