/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap;

import io.contextmap.application.ScanService;
import io.contextmap.domain.TechRadar;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.infrastructure.MojoParameters;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="scan", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class ContextMapScannerMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(property="key", required=true)
    private String key;
    @Parameter(property="systemName")
    private String systemName;
    @Parameter(property="multiModuleComponentName")
    private String multiModuleComponentName;
    @Parameter(property="techradar")
    private TechRadar techRadar;
    @Parameter(defaultValue="${plugin}", readonly=true)
    private PluginDescriptor plugin;

    public void execute() throws MojoExecutionException {
        MojoLogger.initLogger(this.getLog());
        MojoLogger.logger.info("Generating contextmap");
        MojoParameters parameters = this.createParameters();
        ScanService scanService = new ScanService(this.project, this.plugin, parameters);
        scanService.scan();
        MojoLogger.logger.info("Finished scan");
    }

    private MojoParameters createParameters() {
        MojoParameters parameters = new MojoParameters();
        parameters.setKey(this.key);
        parameters.setTechRadar(this.techRadar);
        parameters.setSystemName(this.systemName);
        if (this.multiModuleComponentName != null && this.multiModuleComponentName.length() > 0) {
            parameters.setMultiModuleComponentName(this.multiModuleComponentName);
            parameters.setRootModule(ContextMapScannerMojo.isRootOfModules(this.project));
        }
        return parameters;
    }

    public static boolean isRootOfModules(MavenProject mavenProject) {
        if (mavenProject.getParent() == null) {
            return true;
        }
        if (mavenProject.getParent().getCollectedProjects() == null) {
            return true;
        }
        boolean isChildModule = mavenProject.getParent().getCollectedProjects().contains(mavenProject);
        return !isChildModule;
    }
}

