/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.ReflectionService;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.RestApiInfo;
import io.contextmap.model.Server;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class RestApiInfoService {
    private static final String openApiv2 = "io.swagger.v3.oas.annotations.OpenAPIDefinition";
    private static final String openApiv1 = "io.swagger.annotations.SwaggerDefinition";
    private final ReflectionService reflectionService;

    public RestApiInfoService(ReflectionService reflectionService) {
        this.reflectionService = reflectionService;
    }

    public Optional<RestApiInfo> scan() {
        Optional<RestApiInfo> restApiInfo = this.scanOpenApiV2();
        if (restApiInfo.isPresent()) {
            return restApiInfo;
        }
        return this.scanOpenApiV1();
    }

    private Optional<RestApiInfo> scanOpenApiV2() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(new String[]{openApiv2});
            if (classes.isEmpty()) {
                return Optional.empty();
            }
            Class annotatedClass = (Class)classes.iterator().next();
            Optional<Annotation> annotation = this.reflectionService.getAnnotation(annotatedClass, openApiv2);
            if (!annotation.isPresent()) {
                return Optional.empty();
            }
            RestApiInfo restApiInfo = new RestApiInfo();
            this.reflectionService.getAnnotationFieldValue(annotation.get(), "info").flatMap(infoValue -> this.reflectionService.getAnnotationFieldValue((Annotation)infoValue, "description")).ifPresent(description -> {
                restApiInfo.description = (String)description;
            });
            this.reflectionService.getAnnotationFieldValue(annotation.get(), "servers").ifPresent(serversValue -> {
                Object[] serversAsArray = (Object[])serversValue;
                restApiInfo.servers = Arrays.stream(serversAsArray).map(serverAnnotation -> {
                    Server server = new Server();
                    this.reflectionService.getAnnotationFieldValue((Annotation)serverAnnotation, "description").ifPresent(value -> {
                        server.name = (String)value;
                    });
                    this.reflectionService.getAnnotationFieldValue((Annotation)serverAnnotation, "url").ifPresent(value -> {
                        server.host = (String)value;
                    });
                    return server;
                }).collect(Collectors.toList());
            });
            return Optional.of(restApiInfo);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for open api definition");
            MojoLogger.logger.debug("Exception", e);
            return Optional.empty();
        }
    }

    private Optional<RestApiInfo> scanOpenApiV1() {
        try {
            Set<Class<?>> classes = this.reflectionService.scanForClassesAnnotatedWith(new String[]{openApiv1});
            if (classes.isEmpty()) {
                return Optional.empty();
            }
            Class annotatedClass = (Class)classes.iterator().next();
            Optional<Annotation> annotation = this.reflectionService.getAnnotation(annotatedClass, openApiv1);
            if (!annotation.isPresent()) {
                return Optional.empty();
            }
            RestApiInfo restApiInfo = new RestApiInfo();
            this.reflectionService.getAnnotationFieldValue(annotation.get(), "info").flatMap(infoValue -> this.reflectionService.getAnnotationFieldValue((Annotation)infoValue, "description")).ifPresent(description -> {
                restApiInfo.description = (String)description;
            });
            String host = (String)this.reflectionService.getAnnotationFieldValue(annotation.get(), "host").orElse("");
            String basePath = (String)this.reflectionService.getAnnotationFieldValue(annotation.get(), "basePath").orElse("");
            if (host != null && !host.isEmpty() || basePath != null && !basePath.isEmpty()) {
                Server server = new Server();
                server.name = "Default Host";
                server.host = (host == null ? "" : host) + (basePath == null ? "" : basePath);
                restApiInfo.servers = Collections.singletonList(server);
            }
            return Optional.of(restApiInfo);
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Unable to scan for swagger definition");
            MojoLogger.logger.debug("Exception", e);
            return Optional.empty();
        }
    }
}

