/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.scan;

import io.contextmap.model.ComponentType;
import org.apache.maven.plugin.logging.Log;
import org.reflections.Reflections;

public class ComponentTypeScanner {
    private static final String[] classesUsedByGateways = new String[]{"org.springframework.cloud.netflix.zuul.EnableZuulServer", "org.springframework.cloud.netflix.zuul.EnableZuulProxy"};
    private final Log log;

    public ComponentTypeScanner(Log log) {
        this.log = log;
    }

    public ComponentType scan(Reflections reflections) {
        this.log.debug((CharSequence)"Scanning for the componenttype");
        for (ClassLoader classLoader : reflections.getConfiguration().getClassLoaders()) {
            for (String classUsedByGateway : classesUsedByGateways) {
                if (!this.isClassAvailable(classLoader, classUsedByGateway)) continue;
                this.log.info((CharSequence)"Detected gateway");
                return ComponentType.GATEWAY;
            }
        }
        this.log.info((CharSequence)"Detected microservice");
        return ComponentType.MICROSERVICE;
    }

    private boolean isClassAvailable(ClassLoader classLoader, String classUsedByGateway) {
        try {
            classLoader.loadClass(classUsedByGateway);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }
}

