/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.core.reflection.ObjectToJsonConverter;
import io.contextmap.core.reflection.ReflectionFunctions;
import io.contextmap.infrastructure.MojoLogger;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.reflections.Configuration;
import org.reflections.Reflections_0_9_12_withFixForIssue273;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

public class ReflectionService
implements ObjectToJsonConverter.ObjectToJsonReflection {
    private final MavenProject project;
    private Reflections_0_9_12_withFixForIssue273 cachedReflections;

    public ReflectionService(MavenProject project) {
        this.project = project;
    }

    public boolean isClassInSourceDirectory(Class<?> type) {
        String outputDir = this.project.getBuild().getOutputDirectory();
        if (!new File(outputDir).exists()) {
            return false;
        }
        File classFile = new File(outputDir, type.getName().replace('.', '/') + ".class");
        return classFile.exists();
    }

    public Set<Method> scanForMethodsAnnotatedWith(String[] annotationClasses) throws Exception {
        Reflections_0_9_12_withFixForIssue273 reflections = this.getReflections();
        HashSet<Method> matches = new HashSet<Method>();
        for (String annotationClass : annotationClasses) {
            for (ClassLoader classLoader : reflections.getConfiguration().getClassLoaders()) {
                if (!this.isClassAvailable(classLoader, annotationClass)) continue;
                MojoLogger.logger.debug("Class " + annotationClass + " can be loaded, getting methods annotated with it.");
                Class loadedClass = this.loadClass(classLoader, annotationClass);
                matches.addAll(reflections.getMethodsAnnotatedWith(loadedClass));
            }
        }
        return matches;
    }

    public Set<Class<?>> scanForClassesAnnotatedWith(String[] annotationClasses) throws Exception {
        Reflections_0_9_12_withFixForIssue273 reflections = this.getReflections();
        HashSet matches = new HashSet();
        for (String annotationClass : annotationClasses) {
            for (ClassLoader classLoader : reflections.getConfiguration().getClassLoaders()) {
                if (!this.isClassAvailable(classLoader, annotationClass)) continue;
                MojoLogger.logger.debug("Class " + annotationClass + " can be loaded, getting types annotated with it.");
                Class loadedClass = this.loadClass(classLoader, annotationClass);
                matches.addAll(reflections.getTypesAnnotatedWith(loadedClass));
            }
        }
        return matches;
    }

    public Set<Class<?>> scanForClassesImplementingInterface(String interfaceFQN) throws Exception {
        Reflections_0_9_12_withFixForIssue273 reflections = this.getReflections();
        HashSet matches = new HashSet();
        for (ClassLoader classLoader : reflections.getConfiguration().getClassLoaders()) {
            if (!this.isClassAvailable(classLoader, interfaceFQN)) continue;
            MojoLogger.logger.debug("Class " + interfaceFQN + " can be loaded, getting subtypes.");
            Class loadedClass = this.loadClass(classLoader, interfaceFQN);
            matches.addAll(reflections.getSubTypesOf(loadedClass));
        }
        return matches;
    }

    public Optional<Annotation> getAnnotation(Class<?> type, String annotationFullyQualifiedName) {
        return ReflectionFunctions.getAnnotation(type, (String)annotationFullyQualifiedName);
    }

    public Optional<Annotation> getAnnotation(Method method, String annotationFullyQualifiedName) {
        return ReflectionFunctions.getAnnotation((Method)method, (String)annotationFullyQualifiedName);
    }

    public Optional<Annotation> getAnnotation(Field field, String annotationFullyQualifiedName) {
        return ReflectionFunctions.getAnnotation((Field)field, (String)annotationFullyQualifiedName);
    }

    public Map<Parameter, Annotation> getArgumentsWithAnnotation(Method method, String annotationFullyQualifiedName) {
        return ReflectionFunctions.getArgumentsWithAnnotation((Method)method, (String)annotationFullyQualifiedName);
    }

    public Optional<Object> getAnnotationFieldValue(Annotation annotation, String fieldName) {
        return ReflectionFunctions.getAnnotationFieldValue((Annotation)annotation, (String)fieldName);
    }

    public boolean isClassAvailable(String fullyQualifiedName) {
        try {
            Reflections_0_9_12_withFixForIssue273 reflections = this.getReflections();
            for (ClassLoader classLoader : reflections.getConfiguration().getClassLoaders()) {
                if (!this.isClassAvailable(classLoader, fullyQualifiedName)) continue;
                return true;
            }
        }
        catch (Exception e) {
            MojoLogger.logger.warn("Error while trying to determine whether class is available: " + e.getMessage());
        }
        return false;
    }

    private Reflections_0_9_12_withFixForIssue273 getReflections() throws Exception {
        if (this.cachedReflections == null) {
            this.cachedReflections = this.reflect();
        }
        return this.cachedReflections;
    }

    private Reflections_0_9_12_withFixForIssue273 reflect() throws Exception {
        ArrayList<String> compileSourceOutputs = new ArrayList<String>();
        compileSourceOutputs.add(this.project.getBuild().getOutputDirectory());
        compileSourceOutputs.add(this.project.getBuild().getTestOutputDirectory());
        URL[] sourceFiles = this.buildMavenClasspath("sourceFile", compileSourceOutputs);
        URLClassLoader classLoader = this.createClassLoader();
        ConfigurationBuilder configuration = new ConfigurationBuilder().setUrls(sourceFiles).addClassLoaders(new ClassLoader[]{classLoader}).setScanners(new Scanner[]{new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner()});
        return new Reflections_0_9_12_withFixForIssue273((Configuration)configuration);
    }

    private Class loadClass(ClassLoader classLoader, String className) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private boolean isClassAvailable(ClassLoader classLoader, String className) {
        try {
            classLoader.loadClass(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private URL[] buildMavenClasspath(String type, List<String> classpathElements) throws MojoExecutionException {
        ArrayList<URL> projectClasspathList = new ArrayList<URL>();
        for (String element : classpathElements) {
            try {
                projectClasspathList.add(new File(element).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException(element + " is an invalid classpath element", (Exception)e);
            }
        }
        projectClasspathList.stream().map(URL::toString).sorted().forEach(s -> MojoLogger.logger.debug("Loading " + type + " from " + s));
        return projectClasspathList.toArray(new URL[projectClasspathList.size()]);
    }

    private URLClassLoader createClassLoader() throws MojoExecutionException, DependencyResolutionRequiredException {
        URL[] projectClasspath = this.buildMavenClasspath("classLoader", this.project.getRuntimeClasspathElements());
        URL[] projectTestClasspath = this.buildMavenClasspath("classLoader", this.project.getTestClasspathElements());
        HashSet<URL> noDuplicateSet = new HashSet<URL>();
        noDuplicateSet.addAll(Arrays.asList(projectClasspath));
        noDuplicateSet.addAll(Arrays.asList(projectTestClasspath));
        URL[] noDuplicateArray = new URL[noDuplicateSet.size()];
        noDuplicateArray = noDuplicateSet.toArray(noDuplicateArray);
        return new URLClassLoader(noDuplicateArray, Thread.currentThread().getContextClassLoader());
    }
}

