/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import io.contextmap.scanner.versioncontrol.VersionControlScan;
import io.contextmap.scanner.versioncontrol.VersionControlScanner;
import java.io.File;
import java.util.Locale;
import java.util.Optional;

public class VersionControlService {
    private final VersionControlScanner scanner = new VersionControlScanner((VersionControlLogger)new Logger());

    public VersionControlScan scan() {
        return this.scanner.scan();
    }

    public Optional<String> getRemoteOriginUrl() {
        return this.scanner.getRemoteOriginUrl();
    }

    public Optional<String> getBranch() {
        return this.scanner.getBranch();
    }

    public Optional<String> getRelativePathToVersionRoot(File currentDir) {
        return this.scanner.getRelativePathToVersionRoot(currentDir);
    }

    public String gitUrlToHttp(String url) {
        if (url == null) {
            return url;
        }
        if (url.toLowerCase(Locale.US).startsWith("http://") || url.toLowerCase(Locale.US).startsWith("https://")) {
            return url;
        }
        try {
            int index;
            if (url.endsWith(".git")) {
                index = url.lastIndexOf(".git");
                url = url.substring(0, index);
            }
            if (url.contains(":")) {
                index = url.lastIndexOf(":");
                url = url.substring(0, index) + "/" + url.substring(index + 1);
            }
            if (url.startsWith("git@")) {
                url = "https://" + url.substring(4);
            }
            return url;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class Logger
    implements VersionControlLogger {
        private Logger() {
        }

        public void warn(String message) {
            MojoLogger.logger.warn(message);
        }

        public void info(String message) {
            MojoLogger.logger.info(message);
        }

        public void debug(String message) {
            MojoLogger.logger.debug(message);
        }
    }
}

