/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.application;

import io.contextmap.application.FileContentReader;
import io.contextmap.infrastructure.MojoLogger;
import io.contextmap.model.DecisionRecordDetail;
import io.contextmap.model.DecisionRecordOverview;
import io.contextmap.scanner.decisionrecords.DecisionRecordsScanner;
import io.contextmap.scanner.versioncontrol.VersionControlLogger;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;

public class DecisionRecordService {
    private static final int MAX_DECISIONRECORD_NR_OF_CHARACTERS = 50000;
    private final DecisionRecordsScanner decisionRecordsScanner = new DecisionRecordsScanner((VersionControlLogger)new Logger());

    public List<DecisionRecordOverview> scan(Path baseDir) {
        return this.decisionRecordsScanner.scan(baseDir);
    }

    public Optional<DecisionRecordDetail> createDecisionRecordDetail(String componentId, String parentComponentId, DecisionRecordOverview requestedADR) {
        DecisionRecordDetail adrDetail = new DecisionRecordDetail();
        adrDetail.name = requestedADR.name;
        adrDetail.contentHash = requestedADR.contentHash;
        adrDetail.componentId = componentId;
        adrDetail.parentComponentId = parentComponentId;
        try {
            adrDetail.content = FileContentReader.readContent(requestedADR.filePath, 50000);
        }
        catch (Exception e) {
            MojoLogger.logger.error("Error while reading filecontent " + requestedADR.filePath, e);
            return Optional.empty();
        }
        return Optional.of(adrDetail);
    }

    public static class Logger
    implements VersionControlLogger {
        public void warn(String message) {
            MojoLogger.logger.warn(message);
        }

        public void info(String message) {
            MojoLogger.logger.info(message);
        }

        public void debug(String message) {
            MojoLogger.logger.debug(message);
        }
    }
}

